/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FollowConnectionHandler
extends AbstractHandler {
    private static void selectElement(Object element, GraphicalViewer viewer) {
        EditPart editPart = (EditPart)viewer.getEditPartRegistry().get(element);
        if (editPart != null) {
            if (viewer instanceof AdvancedScrollingGraphicalViewer) {
                ((AdvancedScrollingGraphicalViewer)viewer).selectAndRevealEditPart(editPart);
            } else {
                viewer.select(editPart);
                viewer.reveal(editPart);
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        List<IInterfaceElement> opposites = FollowConnectionHandler.getConnectionOposites(HandlerUtil.getCurrentSelection((ExecutionEvent)event), FollowConnectionHandler.getFBNetwork(editor));
        if (!opposites.isEmpty()) {
            if (opposites.size() == 1) {
                FollowConnectionHandler.selectElement(opposites.get(0), viewer);
            } else {
                FollowConnectionHandler.showOppositeSelectionDialog(opposites, event, viewer);
            }
        }
        return Status.OK_STATUS;
    }

    private static FBNetwork getFBNetwork(IEditorPart editor) {
        FBNetwork network = (FBNetwork)editor.getAdapter(FBNetwork.class);
        if (network == null) {
            FBNetworkElement element = (FBNetworkElement)editor.getAdapter(FBNetworkElement.class);
            if (element instanceof SubApp) {
                return ((SubApp)element).getSubAppNetwork();
            }
            if (element instanceof CFBInstance) {
                return ((CFBInstance)element).getCfbNetwork();
            }
        }
        return network;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        this.setBaseEnabled(editor != null && !FollowConnectionHandler.getConnectionOposites(selection, FollowConnectionHandler.getFBNetwork(editor)).isEmpty());
    }

    private static List<IInterfaceElement> getConnectionOposites(ISelection selection, FBNetwork fbNetwork) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof InterfaceEditPart) {
            IInterfaceElement ie = ((InterfaceEditPart)structuredSelection.getFirstElement()).getModel();
            EList<Connection> connList = FollowConnectionHandler.getConnectionList(ie, fbNetwork);
            return connList.stream().map(con -> con.getSource().equals(ie) ? con.getDestination() : con.getSource()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static EList<Connection> getConnectionList(IInterfaceElement ie, FBNetwork fbNetwork) {
        if (FollowConnectionHandler.isInsideSubappOrViewer(ie, fbNetwork) || FollowConnectionHandler.isInsideTopType(ie)) {
            return ie.isIsInput() ? ie.getOutputConnections() : ie.getInputConnections();
        }
        return ie.isIsInput() ? ie.getInputConnections() : ie.getOutputConnections();
    }

    private static boolean isInsideTopType(IInterfaceElement ie) {
        return ie.eContainer().eContainer() instanceof FBType;
    }

    private static boolean isInsideSubappOrViewer(IInterfaceElement ie, FBNetwork fbNetwork) {
        FBNetworkElement fbnElement = ie.getFBNetworkElement();
        return (fbnElement instanceof SubApp || fbnElement instanceof CFBInstance) && !fbNetwork.equals(fbnElement.eContainer());
    }

    private static void showOppositeSelectionDialog(List<IInterfaceElement> opposites, ExecutionEvent event, GraphicalViewer viewer) throws ExecutionException {
        OppositeSelectionDialog dialog = new OppositeSelectionDialog(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), opposites, viewer);
        dialog.open();
    }

    private static class OppositeSelectionDialog
    extends PopupDialog {
        private final List<IInterfaceElement> opposites;
        private final GraphicalViewer viewer;

        public OppositeSelectionDialog(Shell parent, List<IInterfaceElement> opposites, GraphicalViewer viewer) {
            super(parent, 16, true, false, false, false, false, Messages.FBPaletteViewer_SelectConnectionEnd, null);
            this.opposites = opposites;
            this.viewer = viewer;
        }

        protected void adjustBounds() {
            super.adjustBounds();
            Point pt = this.getShell().getDisplay().getCursorLocation();
            Rectangle rect = this.getShell().getBounds();
            rect.x = pt.x;
            rect.y = pt.y;
            this.getShell().setBounds(rect);
        }

        protected Control createDialogArea(Composite parent) {
            final Composite dialogArea = (Composite)super.createDialogArea(parent);
            ListViewer listViewer = new ListViewer(dialogArea, 4);
            listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IInterfaceElement) {
                        IInterfaceElement iElem = (IInterfaceElement)element;
                        String retVal = "";
                        if (iElem.getFBNetworkElement() != null) {
                            retVal = String.valueOf(iElem.getFBNetworkElement().getName()) + ".";
                        }
                        return String.valueOf(retVal) + iElem.getName();
                    }
                    return super.getText(element);
                }
            });
            listViewer.setInput((Object)this.opposites.toArray());
            listViewer.addSelectionChangedListener(event -> FollowConnectionHandler.selectElement(event.getStructuredSelection().getFirstElement(), this.viewer));
            listViewer.getControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        dialogArea.getShell().close();
                    }
                }
            });
            return dialogArea;
        }
    }
}

