/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.application.editparts.SubAppInternalInterfaceEditPart;
import org.eclipse.fordiac.ide.application.wizards.SaveAsStructWizard;
import org.eclipse.fordiac.ide.model.commands.create.CreateStructFromInterfaceElementsCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToStructHandler
extends AbstractHandler {
    private SaveAsStructWizard wizard;
    private IProject project;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        List<VarDeclaration> varDecls = ConvertToStructHandler.collectSelectedVarDecls((ISelection)sel);
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        CommandStack commandStack = (CommandStack)editor.getAdapter(CommandStack.class);
        FBNetworkElement fb = ConvertToStructHandler.getNetworkElementFromSelectedPins(sel);
        if (fb != null && commandStack != null && !varDecls.isEmpty()) {
            this.project = ConvertToStructHandler.getProject(fb);
            this.invokeSaveWizard(varDecls, editor);
            if (this.wizard.replaceSource()) {
                DataType datatype = TypeLibrary.getTypeLibrary((IProject)this.project).getDataTypeLibrary().getType(this.wizard.getDatatypeName());
                CreateStructFromInterfaceElementsCommand cmd = new CreateStructFromInterfaceElementsCommand(varDecls, datatype);
                if (cmd.canExecute()) {
                    commandStack.execute((Command)cmd);
                } else {
                    ConvertToStructHandler.showInformationDialog(editor);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private static IProject getProject(FBNetworkElement fb) {
        EObject root = EcoreUtil.getRootContainer((EObject)fb);
        if (root instanceof AutomationSystem) {
            return ((AutomationSystem)root).getSystemFile().getProject();
        }
        if (root instanceof FBType) {
            return ((FBType)root).getTypeLibrary().getProject();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection sel = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(!ConvertToStructHandler.collectSelectedVarDecls(sel).isEmpty());
    }

    private void invokeSaveWizard(List<VarDeclaration> varDecls, IEditorPart editor) {
        this.wizard = new SaveAsStructWizard(varDecls, this.project, Messages.ConvertToStructHandler_Title);
        WizardDialog dialog = new WizardDialog(editor.getSite().getShell(), (IWizard)this.wizard);
        dialog.create();
        dialog.open();
    }

    private static void showInformationDialog(IEditorPart editor) {
        MessageDialog.openError((Shell)editor.getSite().getShell(), (String)Messages.ConvertToStructHandler_OperationNotPossible, (String)Messages.ConvertToStructHandler_NotAllowedReasons);
    }

    private static List<VarDeclaration> collectSelectedVarDecls(ISelection sel) {
        if (sel instanceof StructuredSelection) {
            return ((IStructuredSelection)sel).toList().stream().filter(EditPart.class::isInstance).map(ep -> ((EditPart)ep).getModel()).filter(el -> el instanceof VarDeclaration && !(el instanceof AdapterDeclaration)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static FBNetworkElement getNetworkElementFromSelectedPins(IStructuredSelection selectedPins) {
        for (Object pin : selectedPins) {
            InterfaceEditPartForFBNetwork ep;
            if (pin instanceof SubAppInternalInterfaceEditPart && (ep = (SubAppInternalInterfaceEditPart)((Object)pin)).getModel() instanceof VarDeclaration) {
                return ep.getModel().getFBNetworkElement();
            }
            if (!(pin instanceof InterfaceEditPartForFBNetwork) || !((ep = (InterfaceEditPartForFBNetwork)((Object)pin)).getModel() instanceof VarDeclaration)) continue;
            return (FBNetworkElement)ep.getParent().getModel();
        }
        return null;
    }
}

