/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.figures.ConnectionTooltipFigure;
import org.eclipse.fordiac.ide.application.policies.DeleteConnectionEditPolicy;
import org.eclipse.fordiac.ide.application.tools.FBNScrollingConnectionEndpointTracker;
import org.eclipse.fordiac.ide.gef.figures.HideableConnection;
import org.eclipse.fordiac.ide.gef.handles.ScrollingConnectionEndpointHandle;
import org.eclipse.fordiac.ide.gef.policies.FeedbackConnectionEndpointEditPolicy;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.gef.router.RouterUtil;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.UIPlugin;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceConstants;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;

public class ConnectionEditPart
extends AbstractConnectionEditPart {
    private static final float[] BROKEN_CONNECTION_DASH_PATTERN = new float[]{5.0f, 5.0f};
    private static final String HIDDEN = "HIDDEN";
    private static final String HIDEN_CON = "HIDEN_CON";
    private final IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getProperty().equals("EventConnectionConnectorColor") && this.getModel() instanceof EventConnection) {
            this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        }
        if (event.getProperty().equals("AdapterConnectionConnectorColor") && this.getModel() instanceof AdapterConnection) {
            this.getFigure().setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        }
        if (PreferenceConstants.isDataConnectorProperty((String)event.getProperty()) && this.getModel() instanceof DataConnection) {
            this.getFigure().setForegroundColor(this.getDataConnectioncolor());
        }
        if (event.getProperty().equals("hideDataConnections") && this.getModel() instanceof DataConnection) {
            this.getFigure().setVisible((Boolean)event.getNewValue() == false);
        }
        if (event.getProperty().equals("hideEventConnections") && this.getModel() instanceof EventConnection) {
            this.getFigure().setVisible((Boolean)event.getNewValue() == false);
        }
    };
    private Adapter contentAdapter;

    public Connection getModel() {
        return (Connection)super.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new FeedbackConnectionEndpointEditPolicy(){

            protected ConnectionEndpointHandle createConnectionEndPointHandle(org.eclipse.gef.ConnectionEditPart connectionEditPart, int connectionLocator) {
                return new FBNConnectionEndPointHandle(connectionEditPart, connectionLocator);
            }
        });
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new DeleteConnectionEditPolicy());
        if (this.getConnectionFigure().getConnectionRouter() instanceof BendpointPolicyRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", ((BendpointPolicyRouter)this.getConnectionFigure().getConnectionRouter()).getBendpointPolicy((Object)this.getModel()));
        }
    }

    protected IFigure createFigure() {
        PolylineConnection connection = RouterUtil.getConnectionRouterFactory(null).createConnectionFigure();
        String status = this.getModel().getAttributeValue(HIDEN_CON);
        if (connection instanceof HideableConnection) {
            ((HideableConnection)connection).setHidden(status != null && status.equalsIgnoreCase(HIDDEN));
            if (this.getModel() != null && this.getModel().getSourceElement() != null) {
                ((HideableConnection)connection).setLabel(String.valueOf(this.getModel().getSourceElement().getName()) + "." + this.getModel().getSource().getName());
            }
            ((HideableConnection)connection).setModel(this.getModel());
        }
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(7.0, 4.0);
        connection.setTargetDecoration((RotatableDecoration)arrow);
        if (this.getModel() instanceof EventConnection) {
            connection.setVisible(!UIPlugin.getDefault().getPreferenceStore().getBoolean("hideEventConnections"));
        }
        if (this.getModel() instanceof AdapterConnection) {
            connection.setTargetDecoration(null);
            connection.setSourceDecoration(null);
        }
        if (this.getModel() instanceof DataConnection) {
            connection.setVisible(!UIPlugin.getDefault().getPreferenceStore().getBoolean("hideDataConnections"));
        }
        this.setConnectionColor(connection);
        connection.setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel()));
        connection.setLineWidth(1);
        return connection;
    }

    public PolylineConnection getFigure() {
        return (PolylineConnection)super.getFigure();
    }

    private void setConnectionColor(PolylineConnection connection) {
        if (this.getModel() instanceof EventConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"EventConnectionConnectorColor"));
        }
        if (this.getModel() instanceof AdapterConnection) {
            connection.setForegroundColor(PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor"));
        }
        if (this.getModel() instanceof DataConnection) {
            connection.setForegroundColor(this.getDataConnectioncolor());
        }
    }

    private Color getDataConnectioncolor() {
        DataType dataType;
        IInterfaceElement refElement = this.getModel().getSource();
        if (refElement == null) {
            refElement = this.getModel().getDestination();
        }
        if (refElement != null && !ConnectionEditPart.isColoredDataype(dataType = refElement.getType()) && refElement == this.getModel().getSource()) {
            refElement = this.getModel().getDestination();
        }
        if (refElement != null) {
            return PreferenceGetter.getDataColor((String)refElement.getType().getName());
        }
        return PreferenceGetter.getDefaultDataColor();
    }

    private static boolean isColoredDataype(DataType dataType) {
        return dataType == IecTypes.ElementaryTypes.BOOL || dataType instanceof AnyBitType || dataType instanceof AnyIntType || dataType instanceof AnyRealType || dataType instanceof AnyStringType || dataType instanceof StructuredType;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getConnectionFigure() instanceof PolylineConnection && this.getModel() != null) {
            if (this.getModel().isBrokenConnection()) {
                ((PolylineConnection)this.getConnectionFigure()).setLineStyle(6);
                ((PolylineConnection)this.getConnectionFigure()).setLineDash(BROKEN_CONNECTION_DASH_PATTERN);
            } else {
                ((PolylineConnection)this.getConnectionFigure()).setLineStyle(1);
                ((PolylineConnection)this.getConnectionFigure()).setLineDash(null);
            }
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
        }
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Object feature = notification.getFeature();
                    ConnectionEditPart.this.refreshVisuals();
                    if (LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Destination().equals(feature) || LibraryElementPackage.eINSTANCE.getConnection_Source().equals(feature)) {
                        ConnectionEditPart.this.refreshComment();
                    }
                    if (LibraryElementPackage.eINSTANCE.getConnection_Destination().equals(feature)) {
                        ConnectionEditPart.this.setConnectionColor(ConnectionEditPart.this.getFigure());
                        ConnectionEditPart.this.getFigure().setLineWidth(1);
                    }
                }
            };
        }
        return this.contentAdapter;
    }

    private void refreshComment() {
        this.getFigure().setToolTip((IFigure)new ConnectionTooltipFigure(this.getModel()));
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
        }
    }

    public void setTransparency(int value) {
        PolylineConnection connection = this.getFigure();
        connection.setAlpha(value);
        for (Object fig : connection.getChildren()) {
            if (!(fig instanceof Shape)) continue;
            ((Shape)fig).setAlpha(value);
        }
    }

    private static final class FBNConnectionEndPointHandle
    extends ScrollingConnectionEndpointHandle {
        private FBNConnectionEndPointHandle(org.eclipse.gef.ConnectionEditPart owner, int endPoint) {
            super(owner, endPoint);
            this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint){

                protected Point getLocation(PointList points) {
                    Point p = super.getLocation(points);
                    switch (this.getAlignment()) {
                        case 2: {
                            p.x += this.getPreferredSize().width / 2 - 4;
                            break;
                        }
                        case 3: {
                            p.x += -this.getPreferredSize().width / 2 + 4;
                            break;
                        }
                    }
                    return p;
                }
            });
        }

        protected void init() {
            super.init();
            this.setPreferredSize(17, 13);
        }

        protected void paintHandleCenter(Graphics g, Rectangle r) {
            int xbuf = r.x;
            int wbuf = r.width;
            int shrinkVal = this.getInnerShrinkVal();
            r.shrink(shrinkVal, shrinkVal + 1);
            switch (this.getEndPoint()) {
                case 2: {
                    r.x = xbuf;
                    break;
                }
                case 3: {
                    r.x = xbuf + wbuf - r.width;
                    break;
                }
            }
            g.fillRoundRectangle(r, r.height / 2, r.height / 2);
        }

        protected ConnectionEndpointTracker createConnectionEndPointTracker(org.eclipse.gef.ConnectionEditPart connectionEditPart) {
            return new FBNScrollingConnectionEndpointTracker(connectionEditPart);
        }
    }
}

