/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editors.NewInstanceCellEditor;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class NewInstanceDirectEditManager
extends TextDirectEditManager {
    private static final Insets BORDER_INSETS = new Insets(0, 0, 0, 0);
    private static final AbstractBorder BORDER = new AbstractBorder(){

        public Insets getInsets(IFigure figure) {
            return BORDER_INSETS;
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
        }
    };
    private final Palette palette;
    private final boolean useChangeFBType;
    private String initialValue;

    public NewInstanceDirectEditManager(GraphicalEditPart source, Palette palette, boolean useChangeFBType) {
        super(source, NewInstanceCellEditor.class, (CellEditorLocator)new NewInstanceCellEditorLocator());
        this.palette = palette;
        this.useChangeFBType = useChangeFBType;
    }

    public void show() {
        this.initialValue = null;
        super.show();
    }

    public void show(String initialValue) {
        this.initialValue = initialValue;
        super.show();
        if (initialValue != null) {
            Text text = this.getCellEditor().getText();
            text.selectAll();
            this.setDirty(true);
        }
    }

    protected void initCellEditor() {
        this.getCellEditor().getMenuButton().addListener(13, event -> this.showFBInsertPopUpMenu());
        this.getCellEditor().setPalette(this.palette);
        super.initCellEditor();
        if (this.initialValue != null) {
            this.getCellEditor().setValue(this.initialValue);
        }
    }

    public NewInstanceCellEditorLocator getLocator() {
        return (NewInstanceCellEditorLocator)super.getLocator();
    }

    protected NewInstanceCellEditor getCellEditor() {
        return (NewInstanceCellEditor)super.getCellEditor();
    }

    public void updateRefPosition(Point refPoint) {
        this.getLocator().setRefPoint(refPoint);
    }

    protected IFigure getCellEditorFrame() {
        IFigure cellEditorFrame = super.getCellEditorFrame();
        cellEditorFrame.setBorder((Border)BORDER);
        return cellEditorFrame;
    }

    private void showFBInsertPopUpMenu() {
        EditPartViewer viewer = this.getEditPart().getViewer();
        MenuManager mgr = new MenuManager();
        ((FBNetworkContextMenuProvider)viewer.getContextMenu()).buildFBInsertMenu((IMenuManager)mgr, this.getLocator().getRefPoint(), this.useChangeFBType);
        Menu menu = mgr.createContextMenu(viewer.getControl());
        menu.setVisible(true);
        menu.setLocation(viewer.getControl().toDisplay(this.getLocator().getRefPoint()));
        this.getCellEditor().fireCancelEditor();
    }

    public static class NewInstanceCellEditorLocator
    implements CellEditorLocator {
        private Point refPoint = new Point(0, 0);

        public void relocate(CellEditor celleditor) {
            if (celleditor != null) {
                Control control = celleditor.getControl();
                Point pref = control.computeSize(-1, -1);
                control.setBounds(this.refPoint.x - 1, this.refPoint.y - 1, pref.x + 1, pref.y + 1);
            }
        }

        public void setRefPoint(Point refPoint) {
            this.refPoint = refPoint;
        }

        public Point getRefPoint() {
            return this.refPoint;
        }
    }
}

