/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.application.commands.CutAndPasteFromSubAppCommand;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class PasteCommand
extends Command {
    private static final int DEFAULT_DELTA = 20;
    private final Collection<? extends Object> templates;
    private final FBNetwork dstFBNetwork;
    private FBNetwork srcFBNetwork = null;
    private final Map<FBNetworkElement, FBNetworkElement> copiedElements = new HashMap<FBNetworkElement, FBNetworkElement>();
    private final List<FBNetworkElement> elementsToCopy = new ArrayList<FBNetworkElement>();
    private final Set<ConnectionReference> connectionsToCopy = new HashSet<ConnectionReference>();
    private final CompoundCommand connCreateCmds = new CompoundCommand();
    private int xDelta;
    private int yDelta;
    private boolean calcualteDelta = false;
    private Point pasteRefPos;
    private CutAndPasteFromSubAppCommand cutPasteCmd;

    public PasteCommand(List<? extends Object> templates, FBNetwork destination, Point pasteRefPos) {
        this.templates = templates;
        this.dstFBNetwork = destination;
        this.pasteRefPos = pasteRefPos;
        this.calcualteDelta = true;
    }

    public PasteCommand(List<? extends Object> templates, FBNetwork destination, int copyDeltaX, int copyDeltaY) {
        this.templates = templates;
        this.dstFBNetwork = destination;
        this.xDelta = copyDeltaX;
        this.yDelta = copyDeltaY;
    }

    public boolean canExecute() {
        return this.templates != null && this.dstFBNetwork != null;
    }

    public void execute() {
        if (this.dstFBNetwork != null) {
            ErrorMessenger.pauseMessages();
            this.gatherCopyData();
            this.copyFBs();
            this.copyConnections();
            ElementSelector.selectViewObjects(this.copiedElements.values());
            if (!ErrorMessenger.unpauseMessages().isEmpty()) {
                ErrorMessenger.popUpErrorMessage((String)Messages.PasteRecreateNotPossible, (int)-1);
            }
        }
    }

    public void undo() {
        this.connCreateCmds.undo();
        this.dstFBNetwork.getNetworkElements().removeAll(this.copiedElements.values());
        if (this.cutPasteCmd != null) {
            this.cutPasteCmd.undo();
        }
        ElementSelector.selectViewObjects(this.templates);
    }

    public void redo() {
        this.dstFBNetwork.getNetworkElements().addAll(this.copiedElements.values());
        this.connCreateCmds.redo();
        if (this.cutPasteCmd != null) {
            this.cutPasteCmd.redo();
        }
        ElementSelector.selectViewObjects(this.copiedElements.values());
    }

    private void gatherCopyData() {
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        for (Object object : this.templates) {
            if (object instanceof FBNetworkElement) {
                FBNetworkElement element = (FBNetworkElement)object;
                if (this.srcFBNetwork == null) {
                    this.srcFBNetwork = element.getFbNetwork();
                }
                this.elementsToCopy.add(element);
                x = Math.min(x, element.getPosition().getX());
                y = Math.min(y, element.getPosition().getY());
                continue;
            }
            if (object instanceof ConnectionReference) {
                this.connectionsToCopy.add((ConnectionReference)object);
                continue;
            }
            if (!(object instanceof FBNetwork)) continue;
            this.srcFBNetwork = (FBNetwork)object;
        }
        this.updateDelta(x, y);
    }

    private void updateDelta(int x, int y) {
        if (this.calcualteDelta) {
            if (this.pasteRefPos != null) {
                this.xDelta = this.pasteRefPos.x - x;
                this.yDelta = this.pasteRefPos.y - y;
            } else {
                this.xDelta = 20;
                this.yDelta = 20;
            }
        }
    }

    private void copyFBs() {
        for (FBNetworkElement element : this.elementsToCopy) {
            FBNetworkElement copiedElement = this.createElementCopyFB(element);
            this.copiedElements.put(element, copiedElement);
            this.dstFBNetwork.getNetworkElements().add((Object)copiedElement);
            copiedElement.setName(NameRepository.createUniqueName((INamedElement)copiedElement, (String)element.getName()));
        }
    }

    private FBNetworkElement createElementCopyFB(FBNetworkElement element) {
        FBNetworkElement copiedElement = (FBNetworkElement)EcoreUtil.copy((EObject)element);
        for (IInterfaceElement ie : copiedElement.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                ie.getInputConnections().clear();
                continue;
            }
            ie.getOutputConnections().clear();
        }
        copiedElement.setPosition(this.calculatePastePos(element));
        copiedElement.setMapping(null);
        if (copiedElement instanceof StructManipulator) {
            PasteCommand.checkDataValues(element, copiedElement);
        }
        return copiedElement;
    }

    private static void checkDataValues(FBNetworkElement src, FBNetworkElement copy) {
        EList srcList = src.getInterface().getInputVars();
        EList copyList = copy.getInterface().getInputVars();
        int i = 0;
        while (i < srcList.size()) {
            VarDeclaration srcVar = (VarDeclaration)srcList.get(i);
            VarDeclaration copyVar = (VarDeclaration)copyList.get(i);
            if (copyVar.getValue() == null) {
                copyVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            }
            if (srcVar.getValue() != null) {
                copyVar.getValue().setValue(srcVar.getValue().getValue());
            }
            ++i;
        }
    }

    private void copyConnections() {
        for (ConnectionReference connRef : this.connectionsToCopy) {
            AbstractConnectionCreateCommand cmd;
            FBNetworkElement copiedSrc = this.copiedElements.get(connRef.getSourceElement());
            FBNetworkElement copiedDest = this.copiedElements.get(connRef.getDestinationElement());
            if (copiedSrc == null && copiedDest == null || (cmd = this.getConnectionCreateCmd(connRef.getSource())) == null) continue;
            this.copyConnection(connRef, copiedSrc, copiedDest, cmd);
            if (!cmd.canExecute()) continue;
            this.connCreateCmds.add((Command)cmd);
        }
        this.connCreateCmds.execute();
    }

    private AbstractConnectionCreateCommand getConnectionCreateCmd(IInterfaceElement source) {
        EventConnectionCreateCommand cmd = null;
        if (source instanceof Event) {
            cmd = new EventConnectionCreateCommand(this.dstFBNetwork);
        } else if (source instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(this.dstFBNetwork);
        } else if (source instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(this.dstFBNetwork);
        }
        return cmd;
    }

    private void copyConnection(ConnectionReference connRef, FBNetworkElement copiedSrc, FBNetworkElement copiedDest, AbstractConnectionCreateCommand cmd) {
        IInterfaceElement source = this.getInterfaceElement(connRef.getSource(), copiedSrc);
        IInterfaceElement destination = this.getInterfaceElement(connRef.getDestination(), copiedDest);
        cmd.setSource(source);
        cmd.setDestination(destination);
        cmd.setArrangementConstraints(connRef.getRoutingData());
    }

    private IInterfaceElement getInterfaceElement(IInterfaceElement orig, FBNetworkElement copiedElement) {
        if (copiedElement != null) {
            return copiedElement.getInterfaceElement(orig.getName());
        }
        if (this.dstFBNetwork.equals(this.srcFBNetwork)) {
            return orig;
        }
        return null;
    }

    private Position calculatePastePos(FBNetworkElement element) {
        Position pastePos = LibraryElementFactory.eINSTANCE.createPosition();
        pastePos.setX(element.getPosition().getX() + this.xDelta);
        pastePos.setY(element.getPosition().getY() + this.yDelta);
        return pastePos;
    }

    protected CutAndPasteFromSubAppCommand getCutPasteCmd() {
        return this.cutPasteCmd;
    }

    public void setCutPasteCmd(CutAndPasteFromSubAppCommand cutPasteCmd) {
        this.cutPasteCmd = cutPasteCmd;
    }
}

