/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.application.commands.DeleteSubAppInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class MoveElementsFromSubAppCommand
extends Command {
    protected final SubApp sourceSubApp;
    private Point destination;
    private final FBNetwork destinationNetwork;
    protected final List<FBNetworkElement> elements;
    private final Map<FBNetworkElement, Position> oldPos = new HashMap<FBNetworkElement, Position>();
    private final Map<FBNetworkElement, Position> newPos = new HashMap<FBNetworkElement, Position>();
    private final CompoundCommand unmappingCmds = new CompoundCommand();
    private final CompoundCommand deleteConnectionsAndInterfaceElements = new CompoundCommand();
    private final CompoundCommand createConnectionsCommands = new CompoundCommand();
    protected final CompoundCommand createSubAppInterfaceElementCommands = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private final Set<Connection> connsMovedToParent = new HashSet<Connection>();

    public MoveElementsFromSubAppCommand(Collection<FBNetworkElement> elements, Point destination) {
        this.elements = new ArrayList<FBNetworkElement>(elements);
        this.destination = destination;
        this.sourceSubApp = this.getSourceSubapp();
        this.destinationNetwork = this.sourceSubApp != null ? this.sourceSubApp.getFbNetwork() : null;
    }

    private SubApp getSourceSubapp() {
        FBNetworkElement fbel;
        if (!this.elements.isEmpty() && (fbel = this.elements.get(0).getOuterFBNetworkElement()) instanceof SubApp) {
            return (SubApp)fbel;
        }
        return null;
    }

    public boolean canExecute() {
        return this.sourceSubApp != null && this.allElementsFromSameSubApp();
    }

    private boolean allElementsFromSameSubApp() {
        return this.elements.stream().allMatch(el -> this.sourceSubApp.equals(el.getOuterFBNetworkElement()));
    }

    public void execute() {
        this.removeElementsFromSubapp();
        this.addElementsToDestination();
    }

    protected void removeElementsFromSubapp() {
        this.elements.forEach(this::removeElementFromSubapp);
    }

    private void removeElementFromSubapp(FBNetworkElement element) {
        UnmapCommand cmd;
        this.oldPos.put(element, element.getPosition());
        if (element.isMapped() && (cmd = new UnmapCommand(element)).canExecute()) {
            cmd.execute();
            this.unmappingCmds.add((Command)cmd);
        }
        this.sourceSubApp.getSubAppNetwork().getNetworkElements().remove((Object)element);
        this.processElementConnections(element);
    }

    protected void addElementsToDestination() {
        this.elements.forEach(this::addElementToDestination);
        this.setUniqueName.execute();
        this.createConnectionsCommands.execute();
        this.positionElements();
        this.connsMovedToParent.forEach(arg_0 -> ((FBNetwork)this.destinationNetwork).addConnection(arg_0));
    }

    private void addElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().add((Object)element);
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            this.setUniqueName.add((Command)new ChangeNameCommand((INamedElement)element, uniqueName));
        }
    }

    public void redo() {
        this.redoRemoveElementsFromSubapp();
        this.redoAddElementsToDestination();
    }

    protected void redoRemoveElementsFromSubapp() {
        this.unmappingCmds.redo();
        this.elements.forEach(this::redoRemoveElementFromSubapp);
        this.deleteConnectionsAndInterfaceElements.redo();
    }

    private void redoRemoveElementFromSubapp(FBNetworkElement element) {
        this.sourceSubApp.getSubAppNetwork().getNetworkElements().remove((Object)element);
    }

    protected void redoAddElementsToDestination() {
        this.createSubAppInterfaceElementCommands.redo();
        this.elements.forEach(this::redoAddElementToDestination);
        this.setUniqueName.redo();
        this.createConnectionsCommands.redo();
        this.connsMovedToParent.forEach(arg_0 -> ((FBNetwork)this.destinationNetwork).addConnection(arg_0));
    }

    private void redoAddElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().add((Object)element);
        element.setPosition(this.newPos.get(element));
    }

    public void undo() {
        this.undoRemoveElementsFromSubapp();
        this.undoAddElementsToDestination();
    }

    protected void undoRemoveElementsFromSubapp() {
        this.deleteConnectionsAndInterfaceElements.undo();
        this.elements.forEach(this::undoRemoveElementFromSubapp);
        this.unmappingCmds.undo();
    }

    private void undoRemoveElementFromSubapp(FBNetworkElement element) {
        this.newPos.put(element, element.getPosition());
        this.sourceSubApp.getSubAppNetwork().getNetworkElements().add((Object)element);
    }

    protected void undoAddElementsToDestination() {
        this.createConnectionsCommands.undo();
        this.setUniqueName.undo();
        this.elements.forEach(this::undoAddElementToDestination);
        this.connsMovedToParent.forEach(arg_0 -> ((FBNetwork)this.sourceSubApp.getFbNetwork()).addConnection(arg_0));
    }

    private void undoAddElementToDestination(FBNetworkElement element) {
        this.destinationNetwork.getNetworkElements().remove((Object)element);
        element.setPosition(this.oldPos.get(element));
        this.createSubAppInterfaceElementCommands.undo();
    }

    public List<FBNetworkElement> getElements() {
        return this.elements;
    }

    private void positionElements() {
        if (this.destination == null) {
            this.sourceSubApp.getPosition();
        }
        FBNetworkHelper.moveFBNetworkToDestination(this.elements, (Point)this.destination);
    }

    private void processElementConnections(FBNetworkElement fbNetworkElement) {
        for (IInterfaceElement ie : fbNetworkElement.getInterface().getAllInterfaceElements()) {
            if (ie.isIsInput()) {
                for (Connection con : new ArrayList(ie.getInputConnections())) {
                    this.handleConnection(con, con.getSource(), ie);
                }
                continue;
            }
            for (Connection con : new ArrayList(ie.getOutputConnections())) {
                this.handleConnection(con, con.getDestination(), ie);
            }
        }
    }

    private void handleConnection(Connection con, IInterfaceElement opposite, IInterfaceElement ie) {
        if (opposite.getFBNetworkElement() instanceof SubApp && opposite.getFBNetworkElement().equals(this.sourceSubApp)) {
            this.handleCrossingConnections(con, opposite, ie.isIsInput());
        } else if (this.connIsPartOfMovedNetwork(opposite)) {
            this.connsMovedToParent.add(con);
        } else {
            this.handleInnerConnections(con, ie, ie.isIsInput());
        }
    }

    private boolean connIsPartOfMovedNetwork(IInterfaceElement opposite) {
        return this.elements.contains(opposite.getFBNetworkElement());
    }

    private void handleInnerConnections(Connection con, IInterfaceElement ie, boolean isInput) {
        String subAppIEName = MoveElementsFromSubAppCommand.generateSubAppIEName(ie);
        IInterfaceElement subAppIE = this.sourceSubApp.getInterfaceElement(subAppIEName);
        if (subAppIE == null) {
            subAppIE = this.createInterfaceElement(ie, subAppIEName, !isInput);
        }
        this.createConnection(isInput ? con.getSource() : subAppIE, isInput ? subAppIE : con.getDestination(), this.sourceSubApp.getSubAppNetwork());
        this.createConnection(isInput ? subAppIE : con.getSource(), isInput ? con.getDestination() : subAppIE, this.sourceSubApp.getFbNetwork());
        this.addDeleteConnectionOrInterfaceElementCommand((Command)new DeleteConnectionCommand(con));
    }

    private void handleCrossingConnections(Connection con, IInterfaceElement opposite, boolean isInput) {
        EList internalCons = isInput ? opposite.getOutputConnections() : opposite.getInputConnections();
        EList outCons = isInput ? opposite.getInputConnections() : opposite.getOutputConnections();
        for (Connection outCon : new ArrayList(outCons)) {
            this.createCrossingConnection(con, isInput, outCon);
        }
        if (1 == internalCons.size()) {
            this.addDeleteConnectionOrInterfaceElementCommand((Command)new DeleteSubAppInterfaceElementCommand(opposite));
        } else {
            this.addDeleteConnectionOrInterfaceElementCommand((Command)new DeleteConnectionCommand(con));
        }
    }

    private void addDeleteConnectionOrInterfaceElementCommand(Command cmd) {
        if (cmd.canExecute()) {
            cmd.execute();
            this.deleteConnectionsAndInterfaceElements.add(cmd);
        }
    }

    private void createCrossingConnection(Connection con, boolean isInput, Connection outCon) {
        IInterfaceElement sourcePin = isInput ? outCon.getSource() : con.getSource();
        IInterfaceElement destinationPin = isInput ? con.getDestination() : outCon.getDestination();
        this.createConnection(sourcePin, destinationPin, this.destinationNetwork);
    }

    private void createConnection(IInterfaceElement source, IInterfaceElement destination, FBNetwork network) {
        AbstractConnectionCreateCommand cmd = MoveElementsFromSubAppCommand.getCreateConnectionCommand(network, destination);
        cmd.setSource(source);
        cmd.setDestination(destination);
        this.createConnectionsCommands.add((Command)cmd);
    }

    private IInterfaceElement createInterfaceElement(IInterfaceElement ie, String subAppIEName, boolean isInput) {
        CreateSubAppInterfaceElementCommand createSubAppInterfaceElementCommand = new CreateSubAppInterfaceElementCommand(ie.getType(), this.sourceSubApp.getInterface(), isInput, -1);
        createSubAppInterfaceElementCommand.execute();
        createSubAppInterfaceElementCommand.getCreatedElement().setName(subAppIEName);
        if (createSubAppInterfaceElementCommand.getMirroredElement() != null) {
            createSubAppInterfaceElementCommand.getMirroredElement().getCreatedElement().setName(subAppIEName);
        }
        this.createSubAppInterfaceElementCommands.add((Command)createSubAppInterfaceElementCommand);
        return createSubAppInterfaceElementCommand.getCreatedElement();
    }

    private static String generateSubAppIEName(IInterfaceElement ie) {
        return String.valueOf(ie.getFBNetworkElement().getName()) + "_" + ie.getName();
    }

    private static AbstractConnectionCreateCommand getCreateConnectionCommand(FBNetwork fbNetwork, IInterfaceElement subAppIE) {
        Object cmd = null;
        cmd = subAppIE instanceof Event ? new EventConnectionCreateCommand(fbNetwork) : (subAppIE instanceof AdapterDeclaration ? new AdapterConnectionCreateCommand(fbNetwork) : new DataConnectionCreateCommand(fbNetwork));
        return cmd;
    }

    protected void setDestination(Point destination) {
        this.destination = destination;
    }
}

