/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Point;

public class FlattenSubAppCommand
extends Command {
    private final SubApp subapp;
    private final FBNetwork parent;
    private final List<FBNetworkElement> elements = new ArrayList<FBNetworkElement>();
    private final List<EventConnection> transferEventConnections = new ArrayList<EventConnection>();
    private final List<DataConnection> transferDataConnections = new ArrayList<DataConnection>();
    private final List<AdapterConnection> transferAdapterConnections = new ArrayList<AdapterConnection>();
    private final CompoundCommand deleteCommands = new CompoundCommand();
    private final CompoundCommand createCommands = new CompoundCommand();
    private final CompoundCommand mappCommands = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private final Point fbnetworkPosInSubapp;

    public FlattenSubAppCommand(SubApp subapp) {
        super(Messages.FlattenSubAppCommand_LABEL_FlattenSubAppCommand);
        this.subapp = subapp;
        this.parent = subapp.getFbNetwork();
        this.fbnetworkPosInSubapp = FBNetworkHelper.getTopLeftCornerOfFBNetwork((List)subapp.getSubAppNetwork().getNetworkElements());
    }

    public void execute() {
        this.elements.addAll((Collection<FBNetworkElement>)this.subapp.getSubAppNetwork().getNetworkElements());
        FBNetworkHelper.moveFBNetworkByOffset(this.elements, (int)(-this.getOriginalPositionX()), (int)(-this.getOriginalPositionY()));
        this.checkConnections();
        this.createMapCommands();
        this.deleteCommands.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)this.subapp));
        this.deleteCommands.execute();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parent.getNetworkElements().addAll(this.elements);
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parent.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parent.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parent.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.execute();
        this.mappCommands.execute();
        for (FBNetworkElement fbNetworkElement : this.elements) {
            this.ensureUniqueName(fbNetworkElement);
        }
        this.setUniqueName.execute();
        ElementSelector.selectViewObjects(this.elements);
    }

    private void ensureUniqueName(FBNetworkElement element) {
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            this.setUniqueName.add((Command)new ChangeNameCommand((INamedElement)element, uniqueName));
        }
    }

    public void redo() {
        this.deleteCommands.redo();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parent.getNetworkElements().addAll(this.elements);
        FBNetworkHelper.moveFBNetworkByOffset(this.elements, (int)(-this.getOriginalPositionX()), (int)(-this.getOriginalPositionY()));
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parent.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parent.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parent.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.redo();
        this.setUniqueName.redo();
        this.mappCommands.redo();
    }

    public void undo() {
        this.mappCommands.undo();
        this.createCommands.undo();
        this.parent.getNetworkElements().removeAll(this.elements);
        this.subapp.getSubAppNetwork().getNetworkElements().addAll(this.elements);
        FBNetworkHelper.removeXYOffsetForFBNetwork(this.elements);
        this.parent.getEventConnections().removeAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getEventConnections().addAll(this.transferEventConnections);
        this.parent.getDataConnections().removeAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getDataConnections().addAll(this.transferDataConnections);
        this.parent.getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().addAll(this.transferAdapterConnections);
        this.setUniqueName.undo();
        this.deleteCommands.undo();
    }

    private void checkConnections() {
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getEventConnections(), (List)this.transferEventConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getDataConnections(), (List)this.transferDataConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getAdapterConnections(), (List)this.transferAdapterConnections);
    }

    private int getOriginalPositionX() {
        return -this.subapp.getPosition().getX() + this.fbnetworkPosInSubapp.x;
    }

    private int getOriginalPositionY() {
        return -this.subapp.getPosition().getY() + this.fbnetworkPosInSubapp.y;
    }

    private void createMapCommands() {
        if (this.subapp.isMapped()) {
            for (FBNetworkElement fbNetworkElement : this.elements) {
                this.mappCommands.add((Command)new MapToCommand(fbNetworkElement, this.subapp.getResource()));
            }
        }
    }

    private <T extends Connection> void checkConnectionList(List<T> connectionList, List<T> transferConnectionList) {
        for (Connection connection : connectionList) {
            if (connection.getSourceElement() != this.subapp && connection.getDestinationElement() != this.subapp) {
                transferConnectionList.add(connection);
                continue;
            }
            this.deleteCommands.add((Command)new DeleteConnectionCommand(connection));
            if (connection.getSourceElement() == this.subapp && connection.getDestinationElement() == this.subapp) {
                for (Connection inboundConn : connection.getSource().getInputConnections()) {
                    for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                        this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), outboundConn.getDestination()));
                    }
                }
                continue;
            }
            if (connection.getSourceElement() == this.subapp) {
                for (Connection inboundConn : connection.getSource().getInputConnections()) {
                    this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), connection.getDestination()));
                }
                continue;
            }
            if (connection.getDestinationElement() != this.subapp) continue;
            for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                this.createCommands.add((Command)this.createConnCreateCmd(connection.getSource(), outboundConn.getDestination()));
            }
        }
    }

    private AbstractConnectionCreateCommand createConnCreateCmd(IInterfaceElement source, IInterfaceElement destination) {
        EventConnectionCreateCommand cmd = null;
        if (source instanceof Event) {
            cmd = new EventConnectionCreateCommand(this.parent);
        } else if (source instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(this.parent);
        } else if (source instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(this.parent);
        }
        if (cmd != null) {
            cmd.setSource(source);
            cmd.setDestination(destination);
        }
        return cmd;
    }
}

