/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.model.Palette.FBTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.SubApplicationTypePaletteEntry;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class FBNetworkElementInsertAction
extends WorkbenchPartAction {
    private final PaletteEntry paletteEntry;
    private final FBNetwork fbNetwork;

    public FBNetworkElementInsertAction(IWorkbenchPart part, PaletteEntry paletteEntry, FBNetwork fbNetwork) {
        super(part);
        this.paletteEntry = paletteEntry;
        this.fbNetwork = fbNetwork;
        this.setId(paletteEntry.getFile().getFullPath().toString());
        this.setText(paletteEntry.getLabel());
    }

    protected boolean calculateEnabled() {
        return this.paletteEntry != null && this.fbNetwork != null;
    }

    public void run() {
        this.execute((Command)this.createFBNetworkElementCreateCommand());
    }

    private AbstractCreateFBNetworkElementCommand createFBNetworkElementCreateCommand() {
        Point pt = FBNetworkElementInsertAction.getPositionInViewer((IEditorPart)this.getWorkbenchPart());
        if (this.paletteEntry instanceof FBTypePaletteEntry) {
            return new FBCreateCommand((FBTypePaletteEntry)this.paletteEntry, this.fbNetwork, pt.x, pt.y);
        }
        if (this.paletteEntry instanceof SubApplicationTypePaletteEntry) {
            return new CreateSubAppInstanceCommand((SubApplicationTypePaletteEntry)this.paletteEntry, this.fbNetwork, pt.x, pt.y);
        }
        return null;
    }

    private static Point getPositionInViewer(IEditorPart editor) {
        GraphicalViewer viewer = (GraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        return ((FBNetworkContextMenuProvider)viewer.getContextMenu()).getTranslatedAndZoomedPoint();
    }
}

