/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.actions.CopyPasteMessage;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyEditPartsAction
extends SelectionAction {
    public CopyEditPartsAction(IEditorPart editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.COPY.getId());
        this.setText(Messages.CopyEditPartsAction_Text);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    protected boolean calculateEnabled() {
        for (Object obj : this.getSelectedObjects()) {
            Object model;
            if (!(obj instanceof EditPart) || !((model = ((EditPart)obj).getModel()) instanceof FBNetworkElement)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        List<Object> templates = this.getSelectedTemplates();
        CopyPasteMessage info = new CopyPasteMessage(CopyPasteMessage.CopyStatus.COPY, templates);
        Clipboard.getDefault().setContents((Object)info);
    }

    protected List<Object> getSelectedTemplates() {
        HashSet<Connection> connectionSet = new HashSet<Connection>();
        ArrayList<Object> templates = new ArrayList<Object>();
        for (Object obj : this.getSelectedObjects()) {
            Object model;
            if (!(obj instanceof EditPart) || !((model = ((EditPart)obj).getModel()) instanceof FBNetworkElement)) continue;
            templates.add(model);
            templates.addAll(CopyEditPartsAction.getAllFBNElementConnections((FBNetworkElement)model, connectionSet));
        }
        return templates;
    }

    private static Collection<ConnectionReference> getAllFBNElementConnections(FBNetworkElement model, Set<Connection> connectionSet) {
        ArrayList<ConnectionReference> connections = new ArrayList<ConnectionReference>();
        for (IInterfaceElement elem : model.getInterface().getAllInterfaceElements()) {
            CopyEditPartsAction.getConnectionList(elem).stream().filter(conn -> !connectionSet.contains(conn)).forEach(conn -> {
                connectionSet.add((Connection)conn);
                connections.add(new ConnectionReference((Connection)conn));
            });
        }
        return connections;
    }

    private static EList<Connection> getConnectionList(IInterfaceElement elem) {
        return elem.isIsInput() ? elem.getInputConnections() : elem.getOutputConnections();
    }
}

