/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Pair<F, S>
implements Iterable<Object> {
    private F first;
    private S second;
    private static final int HALF_WORD = 16;
    private static final int MASK1 = 65535;
    private static final int MASK2 = -65536;

    public static <T1, T2> Pair<T1, T2> create() {
        return new Pair();
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public static <G, T> List<Pair<G, T>> fromMap(Map<G, T> map) {
        ArrayList<Pair<G, T>> list = new ArrayList<Pair<G, T>>(map.size());
        for (Map.Entry<G, T> entry : map.entrySet()) {
            list.add(new Pair<G, T>(entry));
        }
        return list;
    }

    public Pair() {
    }

    public Pair(F thefirst, S thesecond) {
        this.first = thefirst;
        this.second = thesecond;
    }

    public Pair(Map.Entry<F, S> entry) {
        this.first = entry.getKey();
        this.second = entry.getValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            boolean secondEqual;
            boolean firstEqual;
            Pair other = (Pair)obj;
            boolean bl = this.first == null ? other.first == null : (firstEqual = this.first.equals(other.first));
            boolean bl2 = this.second == null ? other.second == null : (secondEqual = this.second.equals(other.second));
            return firstEqual && secondEqual;
        }
        return false;
    }

    public int hashCode() {
        int firstCode = this.first == null ? 0 : this.first.hashCode();
        int first1 = firstCode & 0xFFFF;
        int first2 = firstCode & 0xFFFF0000;
        int secondCode = this.second == null ? 0 : this.second.hashCode();
        int second1 = secondCode & 0xFFFF;
        int second2 = secondCode & 0xFFFF0000;
        return first1 ^ second2 >> 16 & 0xFFFF | first2 ^ second1 << 16;
    }

    public String toString() {
        if (this.first == null && this.second == null) {
            return "pair(null,null)";
        }
        if (this.first == null) {
            return "pair(null," + this.second.toString() + ")";
        }
        if (this.second == null) {
            return "pair(" + this.first.toString() + ",null)";
        }
        return "pair(" + this.first.toString() + "," + this.second.toString() + ")";
    }

    public void setFirst(F thefirst) {
        this.first = thefirst;
    }

    public F getFirst() {
        return this.first;
    }

    public void setSecond(S thesecond) {
        this.second = thesecond;
    }

    public S getSecond() {
        return this.second;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private boolean visitedFirst = false;
            private boolean visitedSecond = false;

            @Override
            public boolean hasNext() {
                return !this.visitedSecond && (!this.visitedFirst && Pair.this.first != null || Pair.this.second != null);
            }

            @Override
            public Object next() {
                if (!this.visitedSecond && !this.visitedFirst && Pair.this.first != null) {
                    this.visitedFirst = true;
                    return Pair.this.first;
                }
                if (!this.visitedSecond && Pair.this.second != null) {
                    this.visitedSecond = true;
                    return Pair.this.second;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.visitedSecond && Pair.this.second != null) {
                    Pair.this.second = null;
                } else if (this.visitedFirst && Pair.this.first != null) {
                    Pair.this.first = null;
                }
                throw new IllegalStateException();
            }
        };
    }

    public void clear() {
        this.first = null;
        this.second = null;
    }

    public static class FirstComparator<F extends Comparable<F>, S>
    implements Comparator<Pair<F, S>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Pair<F, S> o1, Pair<F, S> o2) {
            return ((Comparable)((Pair)o1).first).compareTo((Comparable)((Pair)o2).first);
        }
    }

    public static class SecondComparator<F, S extends Comparable<S>>
    implements Comparator<Pair<F, S>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Pair<F, S> o1, Pair<F, S> o2) {
            return ((Comparable)((Pair)o1).second).compareTo((Comparable)((Pair)o2).second);
        }
    }
}

