/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.navigator.LibraryElementLabelProvider;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class SystemLabelProvider
extends LibraryElementLabelProvider
implements IDescriptionProvider {
    private static ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemLabelProvider.createFactoryList());

    public SystemLabelProvider() {
        super((AdapterFactory)systemAdapterFactory);
    }

    public String getText(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return SystemLabelProvider.getTextForFiles(file);
        }
        if (object instanceof IResource) {
            return null;
        }
        return super.getText(object);
    }

    private static String getTextForFiles(IFile element) {
        String text = null;
        if ("DTP".equalsIgnoreCase(element.getFileExtension()) || "DEV".equalsIgnoreCase(element.getFileExtension()) || "RES".equalsIgnoreCase(element.getFileExtension()) || "SEG".equalsIgnoreCase(element.getFileExtension()) || "SYS".equalsIgnoreCase(element.getFileExtension())) {
            text = TypeEntry.getTypeNameFromFile((IFile)element);
        }
        return text;
    }

    public Image getImage(Object object) {
        if (object instanceof IResource) {
            IResource res = (IResource)object;
            return this.getImageForResource(res);
        }
        return super.getImage(object);
    }

    private Image getImageForResource(IResource resource) {
        block12: {
            if (!(resource instanceof IFolder)) break block12;
            return switch (resource.getName()) {
                case "Type Library" -> this.getDecoratedImage(resource, FordiacImage.ICON_TYPE_NAVIGATOR.getImageDescriptor());
                case "Standard Libraries", "External Libraries" -> this.getDecoratedImage(resource, FordiacImage.ICON_LINKED_LIBRARY.getImageDescriptor());
                default -> null;
            };
        }
        return null;
    }

    public String getDescription(Object anElement) {
        return super.getText(anElement);
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        factories.add((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }
}

