/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSVideoTrack_h
#define JSVideoTrack_h

#if ENABLE(VIDEO_TRACK)

#include "JSDOMBinding.h"
#include "VideoTrack.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSVideoTrack : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSVideoTrack* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<VideoTrack> impl)
    {
        JSVideoTrack* ptr = new (NotNull, JSC::allocateCell<JSVideoTrack>(globalObject->vm().heap)) JSVideoTrack(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSVideoTrack();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static void visitChildren(JSCell*, JSC::SlotVisitor&);

    VideoTrack* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    VideoTrack* m_impl;
protected:
    JSVideoTrack(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<VideoTrack>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

class JSVideoTrackOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, VideoTrack*)
{
    DEFINE_STATIC_LOCAL(JSVideoTrackOwner, jsVideoTrackOwner, ());
    return &jsVideoTrackOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, VideoTrack*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, VideoTrack*);
VideoTrack* toVideoTrack(JSC::JSValue);

class JSVideoTrackPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSVideoTrackPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackPrototype>(vm.heap)) JSVideoTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSVideoTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesVisitChildren | Base::StructureFlags;
};

// Attributes

JSC::JSValue jsVideoTrackId(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsVideoTrackKind(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsVideoTrackLabel(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsVideoTrackLanguage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsVideoTrackSelected(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSVideoTrackSelected(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif // ENABLE(VIDEO_TRACK)

#endif
