/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)

#include "JSNotification.h"

#include "CallbackFunction.h"
#include "Dictionary.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSNotificationPermissionCallback.h"
#include "KURL.h"
#include "Notification.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNotificationTableValues[] =
{
    { "onshow", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnshow), (intptr_t)setJSNotificationOnshow, NoIntrinsic },
    { "ondisplay", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOndisplay), (intptr_t)setJSNotificationOndisplay, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnerror), (intptr_t)setJSNotificationOnerror, NoIntrinsic },
    { "onclose", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclose), (intptr_t)setJSNotificationOnclose, NoIntrinsic },
    { "onclick", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationOnclick), (intptr_t)setJSNotificationOnclick, NoIntrinsic },
    { "dir", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationDir), (intptr_t)setJSNotificationDir, NoIntrinsic },
    { "replaceId", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationReplaceId), (intptr_t)setJSNotificationReplaceId, NoIntrinsic },
    { "tag", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationTag), (intptr_t)setJSNotificationTag, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotificationTable = { 32, 31, JSNotificationTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNotificationConstructorTableValues[] =
{
    { "permission", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNotificationConstructorPermission), (intptr_t)0, NoIntrinsic },
    { "requestPermission", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationConstructorFunctionRequestPermission), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotificationConstructorTable = { 2, 0, JSNotificationConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSNotificationConstructor::constructJSNotification(ExecState* exec)
{
    JSNotificationConstructor* castedThis = jsCast<JSNotificationConstructor*>(exec->callee());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& title(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Dictionary options(exec, exec->argument(1));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "Notification constructor associated document is unavailable"));
    RefPtr<Notification> object = Notification::create(context, title, options);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSNotificationConstructor::s_info = { "NotificationConstructor", &Base::s_info, &JSNotificationConstructorTable, 0, CREATE_METHOD_TABLE(JSNotificationConstructor) };

JSNotificationConstructor::JSNotificationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNotificationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSNotificationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSNotificationConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSNotificationConstructor, JSDOMWrapper>(exec, &JSNotificationConstructorTable, jsCast<JSNotificationConstructor*>(cell), propertyName, slot);
}

bool JSNotificationConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSNotificationConstructor, JSDOMWrapper>(exec, &JSNotificationConstructorTable, jsCast<JSNotificationConstructor*>(object), propertyName, descriptor);
}

ConstructType JSNotificationConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSNotification;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSNotificationPrototypeTableValues[] =
{
    { "show", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionShow), (intptr_t)0, NoIntrinsic },
    { "cancel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionCancel), (intptr_t)0, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotificationPrototypeTable = { 17, 15, JSNotificationPrototypeTableValues, 0 };
const ClassInfo JSNotificationPrototype::s_info = { "NotificationPrototype", &Base::s_info, &JSNotificationPrototypeTable, 0, CREATE_METHOD_TABLE(JSNotificationPrototype) };

JSObject* JSNotificationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotification>(exec, globalObject);
}

bool JSNotificationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNotificationPrototype* thisObject = jsCast<JSNotificationPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNotificationPrototypeTable, thisObject, propertyName, slot);
}

bool JSNotificationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNotificationPrototype* thisObject = jsCast<JSNotificationPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNotificationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNotification::s_info = { "Notification", &Base::s_info, &JSNotificationTable, 0 , CREATE_METHOD_TABLE(JSNotification) };

JSNotification::JSNotification(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Notification> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNotification::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSNotification::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNotificationPrototype::create(exec->vm(), globalObject, JSNotificationPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSNotification::destroy(JSC::JSCell* cell)
{
    JSNotification* thisObject = static_cast<JSNotification*>(cell);
    thisObject->JSNotification::~JSNotification();
}

JSNotification::~JSNotification()
{
    releaseImplIfNotNull();
}

bool JSNotification::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNotification* thisObject = jsCast<JSNotification*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSNotification, Base>(exec, &JSNotificationTable, thisObject, propertyName, slot);
}

bool JSNotification::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNotification* thisObject = jsCast<JSNotification*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSNotification, Base>(exec, &JSNotificationTable, thisObject, propertyName, descriptor);
}

JSValue jsNotificationConstructorPermission(ExecState* exec, JSValue slotBase, PropertyName)
{
    UNUSED_PARAM(slotBase);
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return jsUndefined();
    JSValue result = jsStringWithCache(exec, Notification::permission(scriptContext));
    return result;
}


JSValue jsNotificationOnshow(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = impl->onshow()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsNotificationOndisplay(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = impl->ondisplay()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsNotificationOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsNotificationOnclose(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = impl->onclose()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsNotificationOnclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = impl->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsNotificationDir(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->dir());
    return result;
}


JSValue jsNotificationReplaceId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->replaceId());
    return result;
}


JSValue jsNotificationTag(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->tag());
    return result;
}


JSValue jsNotificationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNotification* domObject = jsCast<JSNotification*>(asObject(slotBase));
    return JSNotification::getConstructor(exec, domObject->globalObject());
}

void JSNotification::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSNotification* thisObject = jsCast<JSNotification*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSNotification, Base>(exec, propertyName, value, &JSNotificationTable, thisObject, slot);
}

void setJSNotificationOnshow(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->setOnshow(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSNotificationOndisplay(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->setOndisplay(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSNotificationOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSNotificationOnclose(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->setOnclose(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSNotificationOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSNotificationDir(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setDir(nativeValue);
}


void setJSNotificationReplaceId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setReplaceId(nativeValue);
}


void setJSNotificationTag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(thisObject);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setTag(nativeValue);
}


JSValue JSNotification::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNotificationConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->show();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionCancel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->cancel();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationConstructorFunctionRequestPermission(ExecState* exec)
{
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    RefPtr<NotificationPermissionCallback> callback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isFunction())
            return throwVMTypeError(exec);
        callback = createFunctionOnlyCallback<JSNotificationPermissionCallback>(exec, static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject()), exec->argument(0));
    }
    Notification::requestPermission(scriptContext, callback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsNotificationPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwVMTypeError(exec);
    JSNotification* castedThis = jsCast<JSNotification*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotification::s_info);
    Notification* impl = static_cast<Notification*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSNotification::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSNotification* thisObject = jsCast<JSNotification*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSNotification* jsNotification)
{
    if (jsNotification->hasCustomProperties())
        return true;
    if (jsNotification->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSNotificationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNotification* jsNotification = jsCast<JSNotification*>(handle.get().asCell());
    if (jsNotification->impl()->hasPendingActivity())
        return true;
    if (jsNotification->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsNotification))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSNotificationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNotification* jsNotification = jsCast<JSNotification*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNotification->impl(), jsNotification);
    jsNotification->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Notification@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12NotificationE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Notification* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSNotification>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Notification@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12NotificationE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails Notification does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Notification), Notification_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Notification has subclasses. If Notification has subclasses that get passed
    // to toJS() we currently require Notification you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Notification>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSNotification>(exec, globalObject, impl);
}

Notification* toNotification(JSC::JSValue value)
{
    return value.inherits(&JSNotification::s_info) ? jsCast<JSNotification*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
