/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableSectionElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLNames.h"
#include "HTMLTableSectionElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableSectionElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementAlign), (intptr_t)setJSHTMLTableSectionElementAlign, NoIntrinsic },
    { "ch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementCh), (intptr_t)setJSHTMLTableSectionElementCh, NoIntrinsic },
    { "chOff", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementChOff), (intptr_t)setJSHTMLTableSectionElementChOff, NoIntrinsic },
    { "vAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementVAlign), (intptr_t)setJSHTMLTableSectionElementVAlign, NoIntrinsic },
    { "rows", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementRows), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableSectionElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableSectionElementTable = { 16, 15, JSHTMLTableSectionElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTableSectionElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableSectionElementConstructorTable = { 1, 0, JSHTMLTableSectionElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTableSectionElementConstructor::s_info = { "HTMLTableSectionElementConstructor", &Base::s_info, &JSHTMLTableSectionElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTableSectionElementConstructor) };

JSHTMLTableSectionElementConstructor::JSHTMLTableSectionElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTableSectionElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTableSectionElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTableSectionElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableSectionElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableSectionElementConstructorTable, jsCast<JSHTMLTableSectionElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTableSectionElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableSectionElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableSectionElementConstructorTable, jsCast<JSHTMLTableSectionElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableSectionElementPrototypeTableValues[] =
{
    { "insertRow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableSectionElementPrototypeFunctionInsertRow), (intptr_t)0, NoIntrinsic },
    { "deleteRow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableSectionElementPrototypeFunctionDeleteRow), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableSectionElementPrototypeTable = { 5, 3, JSHTMLTableSectionElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTableSectionElementPrototype::s_info = { "HTMLTableSectionElementPrototype", &Base::s_info, &JSHTMLTableSectionElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTableSectionElementPrototype) };

JSObject* JSHTMLTableSectionElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableSectionElement>(exec, globalObject);
}

bool JSHTMLTableSectionElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableSectionElementPrototype* thisObject = jsCast<JSHTMLTableSectionElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableSectionElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTableSectionElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableSectionElementPrototype* thisObject = jsCast<JSHTMLTableSectionElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLTableSectionElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTableSectionElement::s_info = { "HTMLTableSectionElement", &Base::s_info, &JSHTMLTableSectionElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTableSectionElement) };

JSHTMLTableSectionElement::JSHTMLTableSectionElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableSectionElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTableSectionElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTableSectionElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTableSectionElementPrototype::create(exec->vm(), globalObject, JSHTMLTableSectionElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableSectionElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableSectionElement* thisObject = jsCast<JSHTMLTableSectionElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTableSectionElement, Base>(exec, &JSHTMLTableSectionElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTableSectionElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableSectionElement* thisObject = jsCast<JSHTMLTableSectionElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTableSectionElement, Base>(exec, &JSHTMLTableSectionElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTableSectionElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLTableSectionElementCh(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::charAttr));
    return result;
}


JSValue jsHTMLTableSectionElementChOff(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}


JSValue jsHTMLTableSectionElementVAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}


JSValue jsHTMLTableSectionElementRows(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rows()));
    return result;
}


JSValue jsHTMLTableSectionElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableSectionElement* domObject = jsCast<JSHTMLTableSectionElement*>(asObject(slotBase));
    return JSHTMLTableSectionElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTableSectionElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTableSectionElement* thisObject = jsCast<JSHTMLTableSectionElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTableSectionElement, Base>(exec, propertyName, value, &JSHTMLTableSectionElementTable, thisObject, slot);
}

void setJSHTMLTableSectionElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(thisObject);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLTableSectionElementCh(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(thisObject);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::charAttr, nativeValue);
}


void setJSHTMLTableSectionElementChOff(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(thisObject);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::charoffAttr, nativeValue);
}


void setJSHTMLTableSectionElementVAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(thisObject);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::valignAttr, nativeValue);
}


JSValue JSHTMLTableSectionElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableSectionElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableSectionElementPrototypeFunctionInsertRow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableSectionElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableSectionElement::s_info);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertRow(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableSectionElementPrototypeFunctionDeleteRow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableSectionElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableSectionElement* castedThis = jsCast<JSHTMLTableSectionElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableSectionElement::s_info);
    HTMLTableSectionElement* impl = static_cast<HTMLTableSectionElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteRow(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

HTMLTableSectionElement* toHTMLTableSectionElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLTableSectionElement::s_info) ? jsCast<JSHTMLTableSectionElement*>(asObject(value))->impl() : 0;
}

}
