/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocation.h"

#include "ExceptionCode.h"
#include "Geolocation.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSGeolocationPrototypeTableValues[] =
{
    { "getCurrentPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionGetCurrentPosition), (intptr_t)1, NoIntrinsic },
    { "watchPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionWatchPosition), (intptr_t)1, NoIntrinsic },
    { "clearWatch", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsGeolocationPrototypeFunctionClearWatch), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGeolocationPrototypeTable = { 9, 7, JSGeolocationPrototypeTableValues, 0 };
const ClassInfo JSGeolocationPrototype::s_info = { "GeolocationPrototype", &Base::s_info, &JSGeolocationPrototypeTable, 0, CREATE_METHOD_TABLE(JSGeolocationPrototype) };

JSObject* JSGeolocationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeolocation>(exec, globalObject);
}

bool JSGeolocationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSGeolocationPrototype* thisObject = jsCast<JSGeolocationPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSGeolocationPrototypeTable, thisObject, propertyName, slot);
}

bool JSGeolocationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSGeolocationPrototype* thisObject = jsCast<JSGeolocationPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSGeolocationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSGeolocation::s_info = { "Geolocation", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSGeolocation) };

JSGeolocation::JSGeolocation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Geolocation> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSGeolocation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSGeolocation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSGeolocationPrototype::create(exec->vm(), globalObject, JSGeolocationPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSGeolocation::destroy(JSC::JSCell* cell)
{
    JSGeolocation* thisObject = static_cast<JSGeolocation*>(cell);
    thisObject->JSGeolocation::~JSGeolocation();
}

JSGeolocation::~JSGeolocation()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionGetCurrentPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwVMTypeError(exec);
    JSGeolocation* castedThis = jsCast<JSGeolocation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSGeolocation::s_info);
    return JSValue::encode(castedThis->getCurrentPosition(exec));
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionWatchPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwVMTypeError(exec);
    JSGeolocation* castedThis = jsCast<JSGeolocation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSGeolocation::s_info);
    return JSValue::encode(castedThis->watchPosition(exec));
}

EncodedJSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionClearWatch(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwVMTypeError(exec);
    JSGeolocation* castedThis = jsCast<JSGeolocation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSGeolocation::s_info);
    Geolocation* impl = static_cast<Geolocation*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int watchID(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearWatch(watchID);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSGeolocation* jsGeolocation)
{
    if (jsGeolocation->hasCustomProperties())
        return true;
    return false;
}

bool JSGeolocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSGeolocation* jsGeolocation = jsCast<JSGeolocation*>(handle.get().asCell());
    if (!isObservable(jsGeolocation))
        return false;
    Frame* root = jsGeolocation->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSGeolocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSGeolocation* jsGeolocation = jsCast<JSGeolocation*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGeolocation->impl(), jsGeolocation);
    jsGeolocation->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Geolocation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11GeolocationE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Geolocation* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGeolocation>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Geolocation@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11GeolocationE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails Geolocation does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Geolocation), Geolocation_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Geolocation has subclasses. If Geolocation has subclasses that get passed
    // to toJS() we currently require Geolocation you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Geolocation>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSGeolocation>(exec, globalObject, impl);
}

Geolocation* toGeolocation(JSC::JSValue value)
{
    return value.inherits(&JSGeolocation::s_info) ? jsCast<JSGeolocation*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
