# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr7 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK

div a0, a0, a0
mul t0, a0, t0
add t1, a0, t0
add t2, t2, t2
div a1, a1, a1
mul s0, a1, s0
add s1, s0, s1
add s2, s2, s2

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      8
# CHECK-NEXT: Total Cycles:      77
# CHECK-NEXT: Total uOps:        8

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.10
# CHECK-NEXT: IPC:               0.10
# CHECK-NEXT: Block RThroughput: 70.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      35    35.00                       div	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        mul	t0, a0, t0
# CHECK-NEXT:  1      1     0.50                        add	t1, a0, t0
# CHECK-NEXT:  1      1     0.50                        add	t2, t2, t2
# CHECK-NEXT:  1      35    35.00                       div	a1, a1, a1
# CHECK-NEXT:  1      3     1.00                        mul	s0, a1, s0
# CHECK-NEXT:  1      1     0.50                        add	s1, s1, s0
# CHECK-NEXT:  1      1     0.50                        add	s2, s2, s2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SCR7_ALU_DIV_IS
# CHECK-NEXT: [1]   - SCR7_ALU_MUL_IS
# CHECK-NEXT: [2]   - SCR7_DIV
# CHECK-NEXT: [3]   - SCR7_FALU
# CHECK-NEXT: [4]   - SCR7_FDIVSQRT
# CHECK-NEXT: [5]   - SCR7_FMA
# CHECK-NEXT: [6]   - SCR7_FPU_IS
# CHECK-NEXT: [7]   - SCR7_LSU
# CHECK-NEXT: [8]   - SCR7_MUL

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT: 4.00   4.00   70.00   -      -      -      -      -     2.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT: 1.00    -     35.00   -      -      -      -      -      -     div	a0, a0, a0
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     1.00   mul	t0, a0, t0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -     add	t1, a0, t0
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     add	t2, t2, t2
# CHECK-NEXT: 1.00    -     35.00   -      -      -      -      -      -     div	a1, a1, a1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     1.00   mul	s0, a1, s0
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -     add	s1, s1, s0
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     add	s2, s2, s2
