/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.axiom.util.stax.dialect.BEADialect;
import org.apache.axiom.util.stax.dialect.JBossFactoryUnwrapper;
import org.apache.axiom.util.stax.dialect.SJSXPDialect;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.UnknownStAXDialect;
import org.apache.axiom.util.stax.dialect.Version;
import org.apache.axiom.util.stax.dialect.Woodstox4Dialect;
import org.apache.axiom.util.stax.dialect.XLXP1Dialect;
import org.apache.axiom.util.stax.dialect.XLXP2Dialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXDialectDetector {
    private static final Log log = LogFactory.getLog(StAXDialectDetector.class);
    private static final Attributes.Name IMPLEMENTATION_TITLE = new Attributes.Name("Implementation-Title");
    private static final Attributes.Name IMPLEMENTATION_VENDOR = new Attributes.Name("Implementation-Vendor");
    private static final Attributes.Name IMPLEMENTATION_VERSION = new Attributes.Name("Implementation-Version");
    private static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    private static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    private static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private static final JBossFactoryUnwrapper jbossXMLInputFactoryUnwrapper = JBossFactoryUnwrapper.create(XMLInputFactory.class);
    private static final JBossFactoryUnwrapper jbossXMLOutputFactoryUnwrapper = JBossFactoryUnwrapper.create(XMLOutputFactory.class);
    private static final Map<URL, StAXDialect> dialectByUrl = Collections.synchronizedMap(new HashMap());

    private StAXDialectDetector() {
    }

    private static URL getRootUrlForResource(ClassLoader classLoader, String resource) {
        URL url;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((url = classLoader.getResource(resource)) == null) {
            return null;
        }
        String file = url.getFile();
        if (file.endsWith(resource)) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file.substring(0, file.length() - resource.length()));
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    private static URL getRootUrlForClass(Class<?> cls) {
        return StAXDialectDetector.getRootUrlForResource(cls.getClassLoader(), cls.getName().replace('.', '/') + ".class");
    }

    public static XMLInputFactory normalize(XMLInputFactory factory) {
        return StAXDialectDetector.getDialect(factory).normalize(factory);
    }

    public static XMLOutputFactory normalize(XMLOutputFactory factory) {
        return StAXDialectDetector.getDialect(factory).normalize(factory);
    }

    public static StAXDialect getDialect(Class<?> implementationClass) {
        URL rootUrl = StAXDialectDetector.getRootUrlForClass(implementationClass);
        if (rootUrl == null) {
            log.warn((Object)("Unable to determine location of StAX implementation containing class " + implementationClass.getName() + "; using default dialect"));
            return UnknownStAXDialect.INSTANCE;
        }
        return StAXDialectDetector.getDialect(implementationClass.getClassLoader(), rootUrl);
    }

    public static StAXDialect getDialect(XMLInputFactory factory) {
        if (jbossXMLInputFactoryUnwrapper != null) {
            factory = (XMLInputFactory)jbossXMLInputFactoryUnwrapper.unwrap(factory);
        }
        return StAXDialectDetector.getDialect(factory.getClass());
    }

    public static StAXDialect getDialect(XMLOutputFactory factory) {
        if (jbossXMLOutputFactoryUnwrapper != null) {
            factory = (XMLOutputFactory)jbossXMLOutputFactoryUnwrapper.unwrap(factory);
        }
        return StAXDialectDetector.getDialect(factory.getClass());
    }

    private static StAXDialect getDialect(ClassLoader classLoader, URL rootUrl) {
        StAXDialect dialect = dialectByUrl.get(rootUrl);
        if (dialect != null) {
            return dialect;
        }
        dialect = StAXDialectDetector.detectDialect(classLoader, rootUrl);
        dialectByUrl.put(rootUrl, dialect);
        return dialect;
    }

    private static StAXDialect detectDialect(ClassLoader classLoader, URL rootUrl) {
        StAXDialect dialect = StAXDialectDetector.detectDialectFromJarManifest(rootUrl);
        if (dialect == null) {
            dialect = StAXDialectDetector.detectDialectFromClasses(classLoader, rootUrl);
        }
        if (dialect == null) {
            log.warn((Object)("Unable to determine dialect of the StAX implementation at " + rootUrl));
            return UnknownStAXDialect.INSTANCE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected StAX dialect: " + dialect.getName()));
        }
        return dialect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StAXDialect detectDialectFromJarManifest(URL rootUrl) {
        String versionString;
        String vendor;
        int i;
        Manifest manifest;
        if (rootUrl.getProtocol().equals("jrt")) {
            return null;
        }
        try {
            URL metaInfUrl = new URL(rootUrl, "META-INF/MANIFEST.MF");
            try (InputStream is = metaInfUrl.openStream();){
                manifest = new Manifest(is);
            }
        }
        catch (IOException ex) {
            log.warn((Object)("Unable to load manifest for StAX implementation at " + rootUrl));
            return UnknownStAXDialect.INSTANCE;
        }
        Attributes attrs = manifest.getMainAttributes();
        String title = attrs.getValue(IMPLEMENTATION_TITLE);
        String symbolicName = attrs.getValue(BUNDLE_SYMBOLIC_NAME);
        if (symbolicName != null && (i = symbolicName.indexOf(59)) != -1) {
            symbolicName = symbolicName.substring(0, i);
        }
        if ((vendor = attrs.getValue(IMPLEMENTATION_VENDOR)) == null) {
            vendor = attrs.getValue(BUNDLE_VENDOR);
        }
        if ((versionString = attrs.getValue(IMPLEMENTATION_VERSION)) == null) {
            versionString = attrs.getValue(BUNDLE_VERSION);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("StAX implementation at " + rootUrl + " is:\n  Title:         " + title + "\n  Symbolic name: " + symbolicName + "\n  Vendor:        " + vendor + "\n  Version:       " + versionString));
        }
        if (title != null && title.toLowerCase(Locale.ENGLISH).contains("woodstox")) {
            Version version = new Version(versionString);
            switch (version.getComponent(0)) {
                case 4: 
                case 5: 
                case 6: {
                    return Woodstox4Dialect.INSTANCE;
                }
            }
            return null;
        }
        if (title != null && title.indexOf("SJSXP") != -1) {
            return new SJSXPDialect(false);
        }
        if ("com.bea.core.weblogic.stax".equals(symbolicName)) {
            log.warn((Object)"Weblogic's StAX implementation is unsupported and some Axiom features will not work as expected! Please use Woodstox instead.");
            return BEADialect.INSTANCE;
        }
        if ("BEA".equals(vendor)) {
            return BEADialect.INSTANCE;
        }
        if ("com.ibm.ws.prereq.banshee".equals(symbolicName)) {
            return XLXP2Dialect.INSTANCE;
        }
        return null;
    }

    private static Class<?> loadClass(ClassLoader classLoader, URL rootUrl, String name) {
        try {
            Class<?> cls;
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return rootUrl.equals(StAXDialectDetector.getRootUrlForClass(cls = classLoader.loadClass(name))) ? cls : null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static StAXDialect detectDialectFromClasses(ClassLoader classLoader, URL rootUrl) {
        Class<?> superClass;
        Class<?> cls = StAXDialectDetector.loadClass(classLoader, rootUrl, "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
        if (cls != null && ((superClass = cls.getSuperclass()) == XMLOutputFactory.class || superClass.getName().startsWith("com.sun."))) {
            boolean isUnsafeStreamResult;
            try {
                cls.getDeclaredField("fStreamResult");
                isUnsafeStreamResult = true;
            }
            catch (NoSuchFieldException ex) {
                isUnsafeStreamResult = false;
            }
            return new SJSXPDialect(isUnsafeStreamResult);
        }
        cls = StAXDialectDetector.loadClass(classLoader, rootUrl, "com.ibm.xml.xlxp.api.stax.StAXImplConstants");
        if (cls != null) {
            return new XLXP1Dialect();
        }
        cls = StAXDialectDetector.loadClass(classLoader, rootUrl, "com.ibm.xml.xlxp2.api.stax.StAXImplConstants");
        if (cls != null) {
            return new XLXP2Dialect();
        }
        return null;
    }
}

