/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.activation;

import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axiom.util.activation.DataSourceUtils;
import org.apache.axiom.util.activation.SizeLimitExceededException;
import org.apache.axiom.util.activation.SizeLimitedOutputStream;

public final class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static boolean isLargerThan(DataHandler dh, long limit) throws IOException {
        long size = DataSourceUtils.getSize(dh.getDataSource());
        if (size != -1L) {
            return size > limit;
        }
        try {
            dh.writeTo((OutputStream)new SizeLimitedOutputStream(limit));
            return false;
        }
        catch (SizeLimitExceededException ex) {
            return true;
        }
    }
}

