/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.mixin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.common.util.LocaleUtil;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultReason;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomSOAP12FaultReasonMixin
implements AxiomSOAP12FaultReason {
    @Override
    public final Class<? extends CoreNode> coreGetNodeClass() {
        return AxiomSOAP12FaultReason.class;
    }

    @Override
    public final boolean isChildElementAllowed(OMElement child) {
        return child instanceof SOAPFaultText;
    }

    @Override
    public final void addSOAPText(SOAPFaultText soapFaultText) {
        this.addChild(soapFaultText);
    }

    @Override
    public final SOAPFaultText getFirstSOAPText() {
        return (SOAPFaultText)this.getFirstElement();
    }

    @Override
    public final List<SOAPFaultText> getAllSoapTexts() {
        ArrayList<SOAPFaultText> faultTexts = new ArrayList<SOAPFaultText>();
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            faultTexts.add((SOAPFaultText)it.next());
        }
        return faultTexts;
    }

    @Override
    public final SOAPFaultText getSOAPFaultText(String language) {
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            SOAPFaultText text = (SOAPFaultText)it.next();
            if (language != null && !language.equals(text.getLang())) continue;
            return text;
        }
        return null;
    }

    @Override
    public final String getFaultReasonText(Locale locale) {
        String text = "";
        int maxScore = -1;
        Iterator<OMElement> it = this.getChildElements();
        while (it.hasNext()) {
            SOAPFaultText textNode = (SOAPFaultText)it.next();
            String lang = textNode.getLang();
            int score = LocaleUtil.getMatchScore(locale, lang == null ? null : Locale.forLanguageTag(lang));
            if (score <= maxScore) continue;
            text = textNode.getText();
            maxScore = score;
        }
        return text;
    }
}

