/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server.storage.hybrid;

import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.storage.AbstractStorageManagerFallbackStrategy;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.server.storage.hybrid.StorageManagerSelector;

public abstract class FallbackBasedStorageManagerSelector
implements StorageManagerSelector {
    protected final StorageManager warmStorageManager;
    protected final StorageManager coldStorageManager;
    private final AbstractStorageManagerFallbackStrategy fallbackStrategy;

    public FallbackBasedStorageManagerSelector(StorageManager warmStorageManager, StorageManager coldStorageManager, AbstractStorageManagerFallbackStrategy fallbackStrategy) {
        this.warmStorageManager = warmStorageManager;
        this.coldStorageManager = coldStorageManager;
        this.fallbackStrategy = fallbackStrategy;
    }

    abstract StorageManager regularSelect(ShuffleDataFlushEvent var1);

    private StorageManager fallbackSelect(ShuffleDataFlushEvent flushEvent, StorageManager candidateStorageManager) {
        return this.fallbackStrategy.tryFallback(candidateStorageManager, flushEvent, this.warmStorageManager, this.coldStorageManager);
    }

    @Override
    public StorageManager select(ShuffleDataFlushEvent flushEvent) {
        StorageManager storageManager = this.regularSelect(flushEvent);
        if (!storageManager.canWrite(flushEvent) || flushEvent.getRetryTimes() > 0) {
            storageManager = this.fallbackSelect(flushEvent, storageManager);
        }
        return storageManager;
    }
}

