/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.assignment;

import java.util.List;
import java.util.SortedMap;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.strategy.assignment.AssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.host.BasicHostAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.host.HostAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.host.MustDiffHostAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.host.PreferDiffHostAssignmentStrategy;
import org.apache.uniffle.coordinator.strategy.partition.ContinuousSelectPartitionStrategy;
import org.apache.uniffle.coordinator.strategy.partition.RoundSelectPartitionStrategy;
import org.apache.uniffle.coordinator.strategy.partition.SelectPartitionStrategy;

public abstract class AbstractAssignmentStrategy
implements AssignmentStrategy {
    protected final CoordinatorConf conf;
    private HostAssignmentStrategy hostAssignmentStrategy;
    private SelectPartitionStrategy selectPartitionStrategy;

    public AbstractAssignmentStrategy(CoordinatorConf conf) {
        this.conf = conf;
        this.loadHostAssignmentStrategy();
        this.loadSelectPartitionStrategy();
    }

    private void loadSelectPartitionStrategy() {
        SelectPartitionStrategyName selectPartitionStrategyName = (SelectPartitionStrategyName)((Object)this.conf.get(CoordinatorConf.COORDINATOR_SELECT_PARTITION_STRATEGY));
        if (selectPartitionStrategyName == SelectPartitionStrategyName.ROUND) {
            this.selectPartitionStrategy = new RoundSelectPartitionStrategy();
        } else if (selectPartitionStrategyName == SelectPartitionStrategyName.CONTINUOUS) {
            this.selectPartitionStrategy = new ContinuousSelectPartitionStrategy();
        } else {
            throw new RssException("Unsupported partition assignment strategy:" + (Object)((Object)selectPartitionStrategyName));
        }
    }

    private void loadHostAssignmentStrategy() {
        HostAssignmentStrategyName hostAssignmentStrategyName = (HostAssignmentStrategyName)((Object)this.conf.get(CoordinatorConf.COORDINATOR_ASSIGNMENT_HOST_STRATEGY));
        if (hostAssignmentStrategyName == HostAssignmentStrategyName.MUST_DIFF) {
            this.hostAssignmentStrategy = new MustDiffHostAssignmentStrategy();
        } else if (hostAssignmentStrategyName == HostAssignmentStrategyName.PREFER_DIFF) {
            this.hostAssignmentStrategy = new PreferDiffHostAssignmentStrategy();
        } else if (hostAssignmentStrategyName == HostAssignmentStrategyName.NONE) {
            this.hostAssignmentStrategy = new BasicHostAssignmentStrategy();
        } else {
            throw new RssException("Unsupported partition assignment strategy:" + (Object)((Object)hostAssignmentStrategyName));
        }
    }

    protected List<ServerNode> getCandidateNodes(List<ServerNode> allNodes, int expectNum) {
        return this.hostAssignmentStrategy.assign(allNodes, expectNum);
    }

    protected SortedMap<PartitionRange, List<ServerNode>> getPartitionAssignment(int totalPartitionNum, int partitionNumPerRange, int replica, List<ServerNode> candidatesNodes, int estimateTaskConcurrency) {
        return this.selectPartitionStrategy.assign(totalPartitionNum, partitionNumPerRange, replica, candidatesNodes, estimateTaskConcurrency);
    }

    public static enum SelectPartitionStrategyName {
        ROUND,
        CONTINUOUS;

    }

    public static enum HostAssignmentStrategyName {
        MUST_DIFF,
        PREFER_DIFF,
        NONE;

    }
}

