/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp.cmp2;

import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EntityBean;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.cmp.cmp2.Cmp2Entity;
import org.apache.openejb.core.cmp.cmp2.Cmp2Util;

public class SingleValuedCmr<Bean extends EntityBean, Proxy extends EJBLocalObject> {
    private final EntityBean source;
    private final String sourceProperty;
    private final String relatedProperty;
    private final BeanContext relatedInfo;

    public SingleValuedCmr(EntityBean source, String sourceProperty, Class<Bean> relatedType, String relatedProperty) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (relatedType == null) {
            throw new NullPointerException("relatedType is null");
        }
        this.source = source;
        this.sourceProperty = sourceProperty;
        this.relatedProperty = relatedProperty;
        this.relatedInfo = Cmp2Util.getBeanContext(relatedType);
    }

    public Proxy get(Bean entity) throws EJBException {
        if (this.sourceProperty == null) {
            throw new EJBException("Internal error: this container managed relationship is unidirectional and, this entity does not have a cmr field for the relationship");
        }
        if (entity == null) {
            return null;
        }
        Object ejbProxy = Cmp2Util.getEjbProxy(this.relatedInfo, entity);
        return ejbProxy;
    }

    public Bean set(Bean oldBean, Proxy newValue) throws EJBException {
        Object newBean = Cmp2Util.getEntityBean(newValue);
        if (newValue != null && newBean == null) {
            throw new IllegalArgumentException("A deleted bean can not be assigned to a relationship");
        }
        if (this.relatedProperty != null) {
            Object oldBackRef;
            if (oldBean != null) {
                this.toCmp2Entity(oldBean).OpenEJB_removeCmr(this.relatedProperty, this.source);
            }
            if (newValue != null && (oldBackRef = this.toCmp2Entity(newBean).OpenEJB_addCmr(this.relatedProperty, this.source)) != null) {
                this.toCmp2Entity(oldBackRef).OpenEJB_removeCmr(this.sourceProperty, newBean);
            }
        }
        return newBean;
    }

    public void deleted(Bean oldBean) throws EJBException {
        this.set(oldBean, null);
    }

    private Cmp2Entity toCmp2Entity(Object object) {
        return (Cmp2Entity)object;
    }
}

