/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Arrays;
import java.util.List;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationException;
import org.apache.openejb.config.ValidationFailedException;
import org.apache.openejb.config.ValidationFailure;
import org.apache.openejb.config.ValidationWarning;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ReportValidationResults
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_VALIDATION, "org.apache.openejb.config.rules");
    public static final String VALIDATION_LEVEL = "openejb.validation.output.level";

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        Level level2 = SystemInstance.get().getOptions().get(VALIDATION_LEVEL, Level.MEDIUM);
        boolean hasErrors = appModule.hasErrors();
        boolean hasFailures = appModule.hasFailures();
        boolean hasWarnings = appModule.hasWarnings();
        if (!(hasErrors || hasFailures || hasWarnings)) {
            return appModule;
        }
        ValidationFailedException validationFailedException = null;
        List<ValidationContext> contexts = appModule.getValidationContexts();
        for (ValidationContext validationContext : contexts) {
            this.logResults(validationContext, level2);
        }
        ValidationContext uberContext = new ValidationContext(appModule);
        for (ValidationContext context : contexts) {
            for (ValidationError validationError : context.getErrors()) {
                uberContext.addError(validationError);
            }
            for (ValidationException validationException : context.getFailures()) {
                uberContext.addFailure((ValidationFailure)validationException);
            }
            for (ValidationException validationException : context.getWarnings()) {
                uberContext.addWarning((ValidationWarning)validationException);
            }
        }
        if (!hasErrors && !hasFailures) {
            return appModule;
        }
        if (level2 != Level.VERBOSE) {
            List<Level> list2 = Arrays.asList(Level.values());
            list2 = list2.subList(level2.ordinal() + 1, list2.size());
            logger.info("Set the 'openejb.validation.output.level' system property to " + Join.join(" or ", list2) + " for increased validation details.");
        }
        throw new ValidationFailedException("Module failed validation. " + uberContext.getModuleType() + "(name=" + uberContext.getName() + ")", uberContext, validationFailedException);
    }

    private void logResults(ValidationContext context, Level level2) {
        for (ValidationError validationError : context.getErrors()) {
            logger.error(validationError.getPrefix() + " ... " + validationError.getComponentName() + ":\t" + validationError.getMessage(level2.ordinal() + 1));
        }
        for (ValidationException validationException : context.getFailures()) {
            logger.error(((ValidationFailure)validationException).getPrefix() + " ... " + validationException.getComponentName() + ":\t" + validationException.getMessage(level2.ordinal() + 1));
        }
        for (ValidationException validationException : context.getWarnings()) {
            logger.warning(((ValidationWarning)validationException).getPrefix() + " ... " + validationException.getComponentName() + ":\t" + validationException.getMessage(level2.ordinal() + 1));
        }
        if (context.hasErrors() || context.hasFailures()) {
            DeploymentModule module = context.getModule();
            logger.error(String.format("Invalid %s(name=%s, path=%s)", context.getModuleType(), module.getModuleId(), module.getFile()));
        } else if (context.hasWarnings()) {
            if (context.getWarnings().length == 1) {
                logger.warning(context.getWarnings().length + " warning for " + context.getModuleType() + "(path=" + context.getName() + ")");
            } else {
                logger.warning(context.getWarnings().length + " warnings for " + context.getModuleType() + "(path=" + context.getName() + ")");
            }
        }
    }

    private static enum Level {
        TERSE,
        MEDIUM,
        VERBOSE;

    }
}

