/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.event.ClusterMetaDataUpdated;
import org.apache.openejb.client.event.Log;
import org.apache.openejb.client.event.Observes;

public class EventLogger {
    public void log(@Observes ClusterMetaDataUpdated event) {
        Logger logger = Logger.getLogger(event.getClass().getName());
        ClusterMetaData cluster = event.getClusterMetaData();
        String msg = event.toString();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, msg);
        }
        if (logger.isLoggable(Level.FINER)) {
            int i = 0;
            for (URI uri : cluster.getLocations()) {
                String format = String.format("%s #%s %s", msg, ++i, uri.toASCIIString());
                logger.log(Level.FINER, format);
            }
        }
    }

    public void log(@Observes Object event) {
        Log log = event.getClass().getAnnotation(Log.class);
        if (log == null) {
            return;
        }
        Logger logger = Logger.getLogger(event.getClass().getName());
        try {
            Level level = Level.parse(log.value().name());
            if (logger.isLoggable(level)) {
                logger.log(level, event.toString());
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, event.toString());
        }
    }
}

