/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.meta.QueryMetaData;

public class MultiQueryMetaData
extends QueryMetaData {
    private static final long serialVersionUID = 1L;
    private final String _procedureName;
    private final boolean _isTemporary;
    private final List<QueryMetaData> _parts = new ArrayList<QueryMetaData>();
    private final List<Parameter> _params = new ArrayList<Parameter>();

    public MultiQueryMetaData(Class<?> scope, String logicalName, String procedureName, boolean isTemporary) {
        super(logicalName, false);
        this.setLanguage("openjpa.StoredProcedure.SQL");
        this.setSource(null, scope, -1, null);
        this._procedureName = procedureName;
        this._isTemporary = isTemporary;
    }

    public String getProcedureName() {
        return this._procedureName;
    }

    public List<QueryMetaData> getComponents() {
        return this._parts;
    }

    public boolean isEphimeral() {
        return this._isTemporary;
    }

    @Override
    public void setResultSetMappingName(String name) {
        throw new UnsupportedOperationException("Not allowed to set mapping name. It is automatically set");
    }

    @Override
    public void setResultType(Class cls) {
        throw new UnsupportedOperationException("Not allowed to set result type. It is automatically set");
    }

    public void addComponent(Class<?> resultClass) {
        QueryMetaData part = this.newQueryMetaData();
        part.setResultType(resultClass);
        this._parts.add(part);
    }

    public void addComponent(String mappingName) {
        QueryMetaData part = this.newQueryMetaData();
        part.setResultSetMappingName(mappingName);
        this._parts.add(part);
    }

    private QueryMetaData newQueryMetaData() {
        QueryMetaData part = new QueryMetaData(this.getName() + "#" + this._parts.size(), false);
        part.setLanguage(this.getLanguage());
        part.setSource(null, this.getDefiningType(), -1, null);
        return part;
    }

    public QueryMetaData getComponent(int i) {
        if (i < 0 || i >= this._parts.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid index " + i + ". Available " + this._parts.size() + " parts");
        }
        return this._parts.get(i);
    }

    public int getComponentCount() {
        return this._parts.size();
    }

    public void registerParameter(Parameter p) {
        this._params.add(p);
    }

    public List<Parameter> getParameters() {
        return this._params;
    }

    public int getParameterCount() {
        return this._params.size();
    }

    public static class Parameter {
        private final String name;
        private final Class<?> type;
        private final Mode mode;
        private final int position;

        public Parameter(String name, Class<?> type, Mode mode) {
            this.name = name;
            this.type = type;
            this.mode = mode;
            this.position = -1;
        }

        public Parameter(int position, Class<?> type, Mode mode) {
            this.name = null;
            this.type = type;
            this.mode = mode;
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Mode getMode() {
            return this.mode;
        }

        public static enum Mode {
            IN,
            OUT,
            INOUT,
            CURSOR;

        }
    }
}

