/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaSerializer;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.lib.meta.XMLMetaDataSerializer;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.xml.sax.SAXException;

public class XMLSchemaSerializer
extends XMLMetaDataSerializer
implements SchemaSerializer {
    private static final Localizer _loc = Localizer.forPackage(XMLSchemaSerializer.class);
    private final Collection<Table> _tables = new TreeSet<Table>();
    private final Collection<Sequence> _seqs = new TreeSet<Sequence>();

    public XMLSchemaSerializer(JDBCConfiguration conf) {
        this.setLog(conf.getLog("openjpa.jdbc.Schema"));
    }

    @Override
    public Table[] getTables() {
        return this._tables.toArray(new Table[this._tables.size()]);
    }

    @Override
    public void addTable(Table table) {
        if (table != null) {
            this._tables.add(table);
        }
    }

    @Override
    public boolean removeTable(Table table) {
        return this._tables.remove(table);
    }

    public Sequence[] getSequences() {
        return this._seqs.toArray(new Sequence[this._seqs.size()]);
    }

    public void addSequence(Sequence seq) {
        if (seq != null) {
            this._seqs.add(seq);
        }
    }

    public boolean removeSequence(Sequence seq) {
        return this._seqs.remove(seq);
    }

    @Override
    public void addAll(Schema schema) {
        Sequence[] seqs;
        Table[] tables;
        if (schema == null) {
            return;
        }
        for (Table table : tables = schema.getTables()) {
            this.addTable(table);
        }
        for (Sequence seq : seqs = schema.getSequences()) {
            this.addSequence(seq);
        }
    }

    @Override
    public void addAll(SchemaGroup group) {
        Schema[] schemas;
        if (group == null) {
            return;
        }
        for (Schema schema : schemas = group.getSchemas()) {
            this.addAll(schema);
        }
    }

    @Override
    public boolean removeAll(Schema schema) {
        Sequence[] seqs;
        Table[] tables;
        if (schema == null) {
            return false;
        }
        boolean removed = false;
        for (Table table : tables = schema.getTables()) {
            removed |= this.removeTable(table);
        }
        for (Sequence seq : seqs = schema.getSequences()) {
            removed |= this.removeSequence(seq);
        }
        return removed;
    }

    @Override
    public boolean removeAll(SchemaGroup group) {
        Schema[] schemas;
        if (group == null) {
            return false;
        }
        boolean removed = false;
        for (Schema schema : schemas = group.getSchemas()) {
            removed |= this.removeAll(schema);
        }
        return removed;
    }

    @Override
    public void clear() {
        this._tables.clear();
        this._seqs.clear();
    }

    protected Collection getObjects() {
        if (this._seqs.isEmpty()) {
            return this._tables;
        }
        if (this._tables.isEmpty()) {
            return this._seqs;
        }
        ArrayList<Comparable<Sequence>> all = new ArrayList<Comparable<Sequence>>(this._seqs.size() + this._tables.size());
        all.addAll(this._seqs);
        all.addAll(this._tables);
        return all;
    }

    protected void serialize(Collection objs) throws SAXException {
        HashMap schemas = new HashMap();
        for (Object value : objs) {
            Object obj = value;
            String schemaName = obj instanceof Table ? ((Table)obj).getSchemaName() : ((Sequence)obj).getSchemaName();
            LinkedList schemaObjs = (LinkedList)schemas.get(schemaName);
            if (schemaObjs == null) {
                schemaObjs = new LinkedList();
                schemas.put(schemaName, schemaObjs);
            }
            schemaObjs.add(obj);
        }
        this.startElement("schemas");
        Iterator iterator = schemas.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.serializeSchema((String)entry.getKey(), (Collection)entry.getValue());
        }
        this.endElement("schemas");
    }

    private void serializeSchema(String name, Collection<?> objs) throws SAXException {
        if (objs.isEmpty()) {
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(_loc.get("ser-schema", name));
        }
        if (name != null) {
            this.addAttribute("name", name);
        }
        this.startElement("schema");
        for (Object o : objs) {
            Object obj = o;
            if (obj instanceof Table) {
                this.serializeTable((Table)obj);
                continue;
            }
            this.serializeSequence((Sequence)obj);
        }
        this.endElement("schema");
    }

    private void serializeSequence(Sequence seq) throws SAXException {
        this.addAttribute("name", seq.getName());
        if (seq.getInitialValue() != 1) {
            this.addAttribute("initial-value", String.valueOf(seq.getInitialValue()));
        }
        if (seq.getIncrement() > 1) {
            this.addAttribute("increment", String.valueOf(seq.getIncrement()));
        }
        if (seq.getAllocate() > 1) {
            this.addAttribute("allocate", String.valueOf(seq.getAllocate()));
        }
        this.startElement("sequence");
        this.endElement("sequence");
    }

    private void serializeTable(Table table) throws SAXException {
        Unique[] unqs;
        Index[] idxs;
        ForeignKey[] fks;
        Column[] cols;
        this.addAttribute("name", table.getName());
        this.startElement("table");
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null) {
            this.serializePrimaryKey(pk);
        }
        for (Column col : cols = table.getColumns()) {
            this.serializeColumn(col);
        }
        for (ForeignKey fk : fks = table.getForeignKeys()) {
            this.serializeForeignKey(fk);
        }
        for (Index idx : idxs = table.getIndexes()) {
            this.serializeIndex(idx);
        }
        for (Unique unq : unqs = table.getUniques()) {
            this.serializeUnique(unq);
        }
        this.endElement("table");
    }

    private void serializeColumn(Column col) throws SAXException {
        this.addAttribute("name", col.getName());
        this.addAttribute("type", Schemas.getJDBCName(col.getType()));
        if (!StringUtil.isEmpty(col.getTypeName()) && !col.getTypeName().equalsIgnoreCase(Schemas.getJDBCName(col.getType()))) {
            this.addAttribute("type-name", col.getTypeName());
        }
        if (col.isNotNull()) {
            this.addAttribute("not-null", "true");
        }
        if (col.isAutoAssigned()) {
            this.addAttribute("auto-assign", "true");
        }
        if (col.getDefaultString() != null) {
            this.addAttribute("default", col.getDefaultString());
        }
        if (col.getSize() != 0) {
            this.addAttribute("size", String.valueOf(col.getSize()));
        }
        if (col.getDecimalDigits() != 0) {
            this.addAttribute("decimal-digits", String.valueOf(col.getDecimalDigits()));
        }
        this.startElement("column");
        this.endElement("column");
    }

    private void serializePrimaryKey(PrimaryKey pk) throws SAXException {
        Column[] cols;
        if (pk.getName() != null) {
            this.addAttribute("name", pk.getName());
        }
        if (pk.isLogical()) {
            this.addAttribute("logical", "true");
        }
        if ((cols = pk.getColumns()).length == 1) {
            this.addAttribute("column", cols[0].getName());
        }
        this.startElement("pk");
        if (cols.length > 1) {
            for (Column col : cols) {
                this.serializeOn(col);
            }
        }
        this.endElement("pk");
    }

    private void serializeIndex(Index idx) throws SAXException {
        Column[] cols;
        this.addAttribute("name", idx.getName());
        if (idx.isUnique()) {
            this.addAttribute("unique", "true");
        }
        if ((cols = idx.getColumns()).length == 1) {
            this.addAttribute("column", cols[0].getName());
        }
        this.startElement("index");
        if (cols.length > 1) {
            for (Column col : cols) {
                this.serializeOn(col);
            }
        }
        this.endElement("index");
    }

    private void serializeUnique(Unique unq) throws SAXException {
        Column[] cols;
        if (unq.getName() != null) {
            this.addAttribute("name", unq.getName());
        }
        if (unq.isDeferred()) {
            this.addAttribute("deferred", "true");
        }
        if ((cols = unq.getColumns()).length == 1) {
            this.addAttribute("column", cols[0].getName());
        }
        this.startElement("unique");
        if (cols.length > 1) {
            for (Column col : cols) {
                this.serializeOn(col);
            }
        }
        this.endElement("unique");
    }

    private void serializeForeignKey(ForeignKey fk) throws SAXException {
        if (fk.getName() != null) {
            this.addAttribute("name", fk.getName());
        }
        if (fk.isDeferred()) {
            this.addAttribute("deferred", "true");
        }
        if (fk.getDeleteAction() != 1) {
            this.addAttribute("delete-action", ForeignKey.getActionName(fk.getDeleteAction()));
        }
        if (fk.getUpdateAction() != 1 && fk.getUpdateAction() != 2) {
            this.addAttribute("update-action", ForeignKey.getActionName(fk.getUpdateAction()));
        }
        Column[] cols = fk.getColumns();
        Column[] pks = fk.getPrimaryKeyColumns();
        Column[] consts = fk.getConstantColumns();
        Column[] constsPK = fk.getConstantPrimaryKeyColumns();
        this.addAttribute("to-table", fk.getPrimaryKeyTable().getFullName());
        if (cols.length == 1 && consts.length == 0 && constsPK.length == 0) {
            this.addAttribute("column", cols[0].getName());
        }
        this.startElement("fk");
        if (cols.length > 1 || consts.length > 0 || constsPK.length > 0) {
            for (int i = 0; i < cols.length; ++i) {
                this.serializeJoin(cols[i], pks[i]);
            }
        }
        for (Column aConst : consts) {
            this.serializeJoin(aConst, fk.getConstant(aConst));
        }
        for (Column column : constsPK) {
            this.serializeJoin(fk.getPrimaryKeyConstant(column), column);
        }
        this.endElement("fk");
    }

    private void serializeOn(Column col) throws SAXException {
        this.addAttribute("column", col.getName());
        this.startElement("on");
        this.endElement("on");
    }

    private void serializeJoin(Column col, Column pk) throws SAXException {
        this.addAttribute("column", col.getName());
        this.addAttribute("to-column", pk.getName());
        this.startElement("join");
        this.endElement("join");
    }

    private void serializeJoin(Object val, Column pk) throws SAXException {
        this.addAttribute("value", XMLSchemaSerializer.stringifyConstant(val));
        this.addAttribute("to-column", pk.getName());
        this.startElement("join");
        this.endElement("join");
    }

    private void serializeJoin(Column col, Object val) throws SAXException {
        this.addAttribute("column", col.getName());
        this.addAttribute("value", XMLSchemaSerializer.stringifyConstant(val));
        this.startElement("join");
        this.endElement("join");
    }

    private static String stringifyConstant(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof String) {
            return "'" + String.valueOf(val) + "'";
        }
        return val.toString();
    }
}

