/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.TableBase;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.TableSpaceManager;

public class PersistentStoreCollectionDatabase
implements PersistentStoreCollection {
    private Database database;
    private AtomicLong persistentStoreIdSequence = new AtomicLong();
    private final LongKeyHashMap<PersistentStore> rowStoreMap = new LongKeyHashMap();

    public PersistentStoreCollectionDatabase(Database database) {
        this.database = database;
    }

    @Override
    public synchronized PersistentStore getStore(TableBase tableBase) {
        long l = tableBase.getPersistenceId();
        PersistentStore persistentStore = this.rowStoreMap.get(l);
        if (persistentStore == null) {
            persistentStore = this.database.logger.newStore(null, this, tableBase);
            this.rowStoreMap.put(l, persistentStore);
            tableBase.store = persistentStore;
        }
        return persistentStore;
    }

    public synchronized void setStore(TableBase tableBase, PersistentStore persistentStore) {
        this.rowStoreMap.put(tableBase.getPersistenceId(), persistentStore);
        tableBase.store = persistentStore;
    }

    @Override
    public void release() {
        if (this.rowStoreMap.isEmpty()) {
            return;
        }
        Iterator<PersistentStore> iterator = this.rowStoreMap.values().iterator();
        while (iterator.hasNext()) {
            PersistentStore persistentStore = iterator.next();
            persistentStore.release();
        }
        this.rowStoreMap.clear();
    }

    @Override
    public synchronized void removeStore(TableBase tableBase) {
        PersistentStore persistentStore = this.rowStoreMap.get(tableBase.getPersistenceId());
        if (persistentStore != null) {
            persistentStore.removeAll();
            persistentStore.release();
            this.rowStoreMap.remove(tableBase.getPersistenceId());
        }
    }

    public long getNextId() {
        return this.persistentStoreIdSequence.getAndIncrement();
    }

    public void setNewTableSpaces() {
        DataFileCache dataFileCache = this.database.logger.getCache();
        if (dataFileCache == null) {
            return;
        }
        Iterator<PersistentStore> iterator = this.rowStoreMap.values().iterator();
        while (iterator.hasNext()) {
            TableBase tableBase;
            PersistentStore persistentStore = iterator.next();
            if (persistentStore == null || (tableBase = persistentStore.getTable()).getTableType() != 5) continue;
            TableSpaceManager tableSpaceManager = dataFileCache.spaceManager.getTableSpace(tableBase.getSpaceID());
            persistentStore.setSpaceManager(tableSpaceManager);
        }
    }
}

