/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.primitive;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.IdentifiedComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public final class TimerSupport {
    private TimerSupport() {
    }

    @Nonnull
    @NotEmpty
    public static String getTimerName(@Nonnull Object obj) {
        return TimerSupport.getTimerName(obj, null);
    }

    @Nonnull
    @NotEmpty
    public static String getTimerName(@Nonnull Object obj, @Nullable String additionalData) {
        Constraint.isNotNull(obj, "Target object for Timer was null");
        String baseName = null;
        baseName = obj instanceof IdentifiedComponent && StringSupport.trimOrNull(((IdentifiedComponent)obj).getId()) != null ? StringSupport.trimOrNull(((IdentifiedComponent)obj).getId()) : (StringSupport.trimOrNull(obj.toString()) != null ? StringSupport.trimOrNull(obj.toString()) : obj.getClass().getName());
        return TimerSupport.uncheckedGetTimerName(Constraint.isNotNull(baseName, "Base name for Timer was null"), additionalData);
    }

    @Nonnull
    @NotEmpty
    public static String getTimerName(@Nonnull String baseName, @Nullable String additionalData) {
        Constraint.isNotNull(baseName, "Base name for Timer was null");
        return TimerSupport.uncheckedGetTimerName(baseName, additionalData);
    }

    @Nonnull
    @NotEmpty
    private static String uncheckedGetTimerName(@Nonnull String baseName, @Nullable String additionalData) {
        String result = additionalData != null ? String.format("Timer for %s (%s)", baseName, additionalData) : String.format("Timer for %s", baseName);
        assert (result != null);
        return result;
    }
}

