/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.apache.tinkerpop.gremlin.groovy.util.Artifact;
import org.apache.tinkerpop.gremlin.groovy.util.DependencyGrabber;

public class GremlinServerInstall {
    private static GroovyClassLoader dummyClassLoader = new GroovyClassLoader();

    public static void main(String[] arguments) {
        if (arguments.length != 3) {
            System.out.println("Usage: <group> <artifact> <version>");
        } else {
            try {
                Artifact artifact = new Artifact(arguments[0], arguments[1], arguments[2]);
                DependencyGrabber grabber = new DependencyGrabber((ClassLoader)dummyClassLoader, GremlinServerInstall.getExtensionPath());
                grabber.copyDependenciesToPath(artifact);
            }
            catch (Exception iae) {
                System.out.println(String.format("Could not install the dependency: %s", iae.getMessage()));
                iae.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static File getExtensionPath() {
        return new File(System.getProperty("user.dir"), "ext");
    }
}

