/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Host;

public interface Vertex
extends Element,
Host {
    public static final String DEFAULT_LABEL = "vertex";
    public static final Object[] EMPTY_ARGS = new Object[0];

    public Edge addEdge(String var1, Vertex var2, Object ... var3);

    default public <V> VertexProperty<V> property(String key) {
        Iterator<VertexProperty<V>> iterator = this.properties(key);
        if (iterator.hasNext()) {
            VertexProperty<V> property = iterator.next();
            if (iterator.hasNext()) {
                throw Exceptions.multiplePropertiesExistForProvidedKey(key);
            }
            return property;
        }
        return VertexProperty.empty();
    }

    default public <V> VertexProperty<V> property(String key, V value) {
        return this.property(key, value, EMPTY_ARGS);
    }

    default public <V> VertexProperty<V> property(String key, V value, Object ... keyValues) {
        return this.property(this.graph().features().vertex().getCardinality(key), key, value, keyValues);
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality var1, String var2, V var3, Object ... var4);

    public Iterator<Edge> edges(Direction var1, String ... var2);

    public Iterator<Vertex> vertices(Direction var1, String ... var2);

    public <V> Iterator<VertexProperty<V>> properties(String ... var1);

    public static class Exceptions {
        private Exceptions() {
        }

        public static UnsupportedOperationException userSuppliedIdsNotSupported() {
            return new UnsupportedOperationException("Vertex does not support user supplied identifiers");
        }

        public static UnsupportedOperationException userSuppliedIdsOfThisTypeNotSupported() {
            return new UnsupportedOperationException("Vertex does not support user supplied identifiers of this type");
        }

        public static IllegalStateException vertexRemovalNotSupported() {
            return new IllegalStateException("Vertex removal are not supported");
        }

        public static IllegalStateException edgeAdditionsNotSupported() {
            return new IllegalStateException("Edge additions not supported");
        }

        public static IllegalStateException multiplePropertiesExistForProvidedKey(String propertyKey) {
            return new IllegalStateException("Multiple properties exist for the provided key, use Vertex.properties(" + propertyKey + ')');
        }
    }
}

