/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.corpus;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class DocumentationReader {
    private static final Pattern sourceCodePattern = Pattern.compile("\\[gremlin-groovy.*\\].*");
    private static final Pattern startGremlinPattern = Pattern.compile("^g\\..*");
    private static final Set<String> throwAway = new HashSet<String>(Arrays.asList("g.inject(g.withComputer().V().shortestPath().with(ShortestPath.distance, 'weight').with(ShortestPath.includeEdges, true).with(ShortestPath.maxDistance, 1).toList().toArray()).map(unfold().values('name','weight').fold())"));

    public static Set<String> parse(String documentationDir) throws IOException {
        LinkedHashSet<String> gremlins = new LinkedHashSet<String>();
        Files.find(Paths.get(documentationDir, new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && (filePath.toString().endsWith("traversal.asciidoc") || filePath.toString().contains("recipes")), new FileVisitOption[0]).sorted().forEach(f -> {
            String currentGremlin = "";
            int openSnippet = 0;
            try {
                List<String> lines = Files.readAllLines(f, StandardCharsets.UTF_8);
                for (String line : lines) {
                    String cleanLine = line.replaceAll("<\\d*>", "").trim();
                    int pos = cleanLine.indexOf("//");
                    if (pos > 0) {
                        cleanLine = cleanLine.substring(0, pos).trim();
                    }
                    if (sourceCodePattern.matcher(cleanLine).matches() || openSnippet > 0 && cleanLine.equals("----")) {
                        if (openSnippet > 1) {
                            openSnippet = 0;
                            continue;
                        }
                        ++openSnippet;
                        continue;
                    }
                    if (openSnippet <= 0 || !startGremlinPattern.matcher(cleanLine).matches() && !DocumentationReader.isTerminated(currentGremlin) || DocumentationReader.isTerminated(currentGremlin = currentGremlin + cleanLine)) continue;
                    String gremlinToAdd = DocumentationReader.replaceVariables(currentGremlin.trim());
                    if (!throwAway.contains(gremlinToAdd)) {
                        gremlins.add(gremlinToAdd);
                    }
                    currentGremlin = "";
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        });
        return gremlins;
    }

    private static boolean isTerminated(String gremlin) {
        return gremlin.endsWith(".") || gremlin.endsWith("(") || gremlin.endsWith(",");
    }

    private static String replaceVariables(String gremlin) {
        return gremlin.replace("relations", "\"relations\"").replace("places.size()", "6").replace("places", "\"places\"").replace("ids", "\"ids\"").replace("vRexsterJob1", "\"rj1\"").replace("vBlueprintsJob1", "\"bj1\"").replace("weightFilter.clone()", "{it}").replace("weightFilter", "{it}").replace("vBob", "\"bob\"").replace("vMarko", "\"marko\"").replace("vPeter", "\"peter\"").replace("vStephen", "\"stephen\"").replace("maps", "[:]").replace("v1", "new Vertex(1,\"vertex\")").replace("v2", "new Vertex(2,\"vertex\")").replace("input.head()", "\"head\"").replace("input.tail().size()", "6").replace("input.tail()", "\"tail\"").replace("System.out.&println", "{it}").replace("persons", "\"persons\"").replace("marko.value('age')", "11").replace("seedStrategy", "new SeedStrategy(seed: 99999)").replace(".getClass()", "").replace("result.toArray()", "4").replace("vA.value('amount')", "0.0").replace("vA", "\"vA\"");
    }
}

