/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.configuration;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesHighAvailabilityOptions;

public class KubernetesLeaderElectionConfiguration {
    private final String clusterId;
    private final String configMapName;
    private final String lockIdentity;
    private final Duration leaseDuration;
    private final Duration renewDeadline;
    private final Duration retryPeriod;

    public KubernetesLeaderElectionConfiguration(String configMapName, String lockIdentity, Configuration config) {
        this.clusterId = config.getString(KubernetesConfigOptions.CLUSTER_ID);
        this.configMapName = configMapName;
        this.lockIdentity = lockIdentity;
        this.leaseDuration = (Duration)config.get(KubernetesHighAvailabilityOptions.KUBERNETES_LEASE_DURATION);
        this.renewDeadline = (Duration)config.get(KubernetesHighAvailabilityOptions.KUBERNETES_RENEW_DEADLINE);
        this.retryPeriod = (Duration)config.get(KubernetesHighAvailabilityOptions.KUBERNETES_RETRY_PERIOD);
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getConfigMapName() {
        return this.configMapName;
    }

    public String getLockIdentity() {
        return this.lockIdentity;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }
}

