/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.streampark.common.enums.ClusterState;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.mapper.FlinkClusterMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.YarnQueueService;
import org.apache.streampark.console.core.task.FlinkRESTAPIWatcher;
import org.apache.streampark.flink.client.FlinkClient;
import org.apache.streampark.flink.client.bean.DeployRequest;
import org.apache.streampark.flink.client.bean.DeployResponse;
import org.apache.streampark.flink.client.bean.KubernetesDeployParam;
import org.apache.streampark.flink.client.bean.ShutDownRequest;
import org.apache.streampark.flink.client.bean.ShutDownResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class FlinkClusterServiceImpl
extends ServiceImpl<FlinkClusterMapper, FlinkCluster>
implements FlinkClusterService {
    private static final Logger log = LoggerFactory.getLogger(FlinkClusterServiceImpl.class);
    private static final String ERROR_CLUSTER_QUEUE_HINT = "Queue label '%s' isn't available in database, please add it first.";
    private final ExecutorService executorService = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 5, Runtime.getRuntime().availableProcessors() * 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), ThreadUtils.threadFactory((String)"streampark-cluster-executor"), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private YarnQueueService yarnQueueService;

    @Override
    public ResponseResult check(FlinkCluster cluster) {
        Boolean existsByClusterId;
        ResponseResult result = new ResponseResult();
        result.setStatus(0);
        Boolean existsByClusterName = this.existsByClusterName(cluster.getClusterName(), cluster.getId());
        if (existsByClusterName.booleanValue()) {
            result.setMsg("clusterName is already exists,please check!");
            result.setStatus(1);
            return result;
        }
        String clusterId = cluster.getClusterId();
        if (StringUtils.isNotEmpty((CharSequence)clusterId) && (existsByClusterId = this.existsByClusterId(clusterId, cluster.getId())).booleanValue()) {
            result.setMsg("the clusterId " + clusterId + " is already exists,please check!");
            result.setStatus(2);
            return result;
        }
        if (ExecutionMode.REMOTE.equals((Object)cluster.getExecutionModeEnum())) {
            if (!cluster.verifyClusterConnection()) {
                result.setMsg("the remote cluster connection failed, please check!");
                result.setStatus(3);
                return result;
            }
        } else if (ExecutionMode.YARN_SESSION.equals((Object)cluster.getExecutionModeEnum()) && cluster.getClusterId() != null && !cluster.verifyClusterConnection()) {
            result.setMsg("the flink cluster connection failed, please check!");
            result.setStatus(4);
            return result;
        }
        return result;
    }

    @Override
    public Boolean create(FlinkCluster flinkCluster) {
        flinkCluster.setUserId(this.commonService.getUserId());
        boolean successful = this.validateQueueIfNeeded(flinkCluster);
        ApiAlertException.throwIfFalse(successful, String.format(ERROR_CLUSTER_QUEUE_HINT, flinkCluster.getYarnQueue()));
        flinkCluster.setCreateTime(new Date());
        if (ExecutionMode.REMOTE.equals((Object)flinkCluster.getExecutionModeEnum())) {
            flinkCluster.setClusterState(ClusterState.STARTED.getValue());
        } else {
            flinkCluster.setClusterState(ClusterState.CREATED.getValue());
        }
        return this.save(flinkCluster);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start(FlinkCluster cluster) {
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(cluster.getId());
        try {
            ExecutionMode executionModeEnum = flinkCluster.getExecutionModeEnum();
            KubernetesDeployParam kubernetesDeployParam = null;
            switch (executionModeEnum) {
                case YARN_SESSION: {
                    break;
                }
                case KUBERNETES_NATIVE_SESSION: {
                    kubernetesDeployParam = new KubernetesDeployParam(flinkCluster.getClusterId(), flinkCluster.getK8sNamespace(), flinkCluster.getK8sConf(), flinkCluster.getServiceAccount(), flinkCluster.getFlinkImage(), flinkCluster.getK8sRestExposedTypeEnum());
                    break;
                }
                default: {
                    throw new ApiAlertException("the ExecutionModeEnum " + executionModeEnum.getName() + "can't start!");
                }
            }
            FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(flinkCluster.getVersionId());
            DeployRequest deployRequest = new DeployRequest(flinkEnv.getFlinkVersion(), executionModeEnum, flinkCluster.getProperties(), flinkCluster.getClusterId(), kubernetesDeployParam);
            log.info("deploy cluster request " + deployRequest);
            Future<DeployResponse> future = this.executorService.submit(() -> FlinkClient.deploy((DeployRequest)deployRequest));
            DeployResponse deployResponse = future.get(60L, TimeUnit.SECONDS);
            if (deployResponse != null) {
                if (ExecutionMode.YARN_SESSION.equals((Object)executionModeEnum)) {
                    String address = YarnUtils.getRMWebAppURL((boolean)true) + "/proxy/" + deployResponse.clusterId() + "/";
                    flinkCluster.setAddress(address);
                } else {
                    flinkCluster.setAddress(deployResponse.address());
                }
            } else {
                throw new ApiAlertException("deploy cluster failed, unknown reason\uff0cplease check you params or StreamPark error log");
            }
            flinkCluster.setClusterId(deployResponse.clusterId());
            flinkCluster.setClusterState(ClusterState.STARTED.getValue());
            flinkCluster.setException(null);
            this.updateById(flinkCluster);
            FlinkRESTAPIWatcher.removeFlinkCluster(flinkCluster);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            flinkCluster.setClusterState(ClusterState.STOPPED.getValue());
            flinkCluster.setException(e.toString());
            this.updateById(flinkCluster);
            throw new ApiDetailException(e);
        }
    }

    @Override
    public void update(FlinkCluster cluster) {
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(cluster.getId());
        boolean success = this.validateQueueIfNeeded(flinkCluster, cluster);
        ApiAlertException.throwIfFalse(success, String.format(ERROR_CLUSTER_QUEUE_HINT, cluster.getYarnQueue()));
        flinkCluster.setClusterName(cluster.getClusterName());
        flinkCluster.setDescription(cluster.getDescription());
        if (ExecutionMode.REMOTE.equals((Object)flinkCluster.getExecutionModeEnum())) {
            flinkCluster.setAddress(cluster.getAddress());
        } else {
            flinkCluster.setAddress(null);
            flinkCluster.setClusterId(cluster.getClusterId());
            flinkCluster.setVersionId(cluster.getVersionId());
            flinkCluster.setDynamicProperties(cluster.getDynamicProperties());
            flinkCluster.setOptions(cluster.getOptions());
            flinkCluster.setResolveOrder(cluster.getResolveOrder());
            flinkCluster.setK8sHadoopIntegration(cluster.getK8sHadoopIntegration());
            flinkCluster.setK8sConf(cluster.getK8sConf());
            flinkCluster.setK8sNamespace(cluster.getK8sNamespace());
            flinkCluster.setK8sRestExposedType(cluster.getK8sRestExposedType());
            flinkCluster.setServiceAccount(cluster.getServiceAccount());
            flinkCluster.setFlinkImage(cluster.getFlinkImage());
            flinkCluster.setYarnQueue(cluster.getYarnQueue());
        }
        try {
            this.updateById(flinkCluster);
        }
        catch (Exception e) {
            throw new ApiDetailException("update cluster failed, Caused By: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void shutdown(FlinkCluster cluster) {
        boolean existsRunningJob;
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(cluster.getId());
        ExecutionMode executionModeEnum = flinkCluster.getExecutionModeEnum();
        String clusterId = flinkCluster.getClusterId();
        KubernetesDeployParam kubernetesDeployParam = null;
        switch (executionModeEnum) {
            case YARN_SESSION: {
                break;
            }
            case KUBERNETES_NATIVE_SESSION: {
                kubernetesDeployParam = new KubernetesDeployParam(flinkCluster.getClusterId(), flinkCluster.getK8sNamespace(), flinkCluster.getK8sConf(), flinkCluster.getServiceAccount(), flinkCluster.getFlinkImage(), flinkCluster.getK8sRestExposedTypeEnum());
                break;
            }
            default: {
                throw new ApiAlertException("the ExecutionModeEnum " + executionModeEnum.getName() + "can't shutdown!");
            }
        }
        if (StringUtils.isBlank((CharSequence)clusterId)) {
            throw new ApiAlertException("the clusterId can not be empty!");
        }
        if (ExecutionMode.YARN_SESSION.equals((Object)executionModeEnum)) {
            if (ClusterState.STARTED.equals((Object)ClusterState.of((Integer)flinkCluster.getClusterState()))) {
                if (!flinkCluster.verifyClusterConnection()) {
                    flinkCluster.setAddress(null);
                    flinkCluster.setClusterState(ClusterState.LOST.getValue());
                    this.updateById(flinkCluster);
                    throw new ApiAlertException("current cluster is not active, please check");
                }
            } else {
                throw new ApiAlertException("current cluster is not active, please check");
            }
        }
        if (existsRunningJob = this.applicationService.existsRunningJobByClusterId(flinkCluster.getId())) {
            throw new ApiAlertException("some app is running on this cluster, the cluster cannot be shutdown");
        }
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(flinkCluster.getVersionId());
        ShutDownRequest stopRequest = new ShutDownRequest(flinkEnv.getFlinkVersion(), executionModeEnum, flinkCluster.getProperties(), clusterId, kubernetesDeployParam);
        try {
            Future<ShutDownResponse> future = this.executorService.submit(() -> FlinkClient.shutdown((ShutDownRequest)stopRequest));
            ShutDownResponse shutDownResponse = future.get(60L, TimeUnit.SECONDS);
            if (shutDownResponse == null) {
                throw new ApiAlertException("get shutdown response failed");
            }
            flinkCluster.setAddress(null);
            flinkCluster.setClusterState(ClusterState.STOPPED.getValue());
            this.updateById(flinkCluster);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            flinkCluster.setException(e.toString());
            this.updateById(flinkCluster);
            throw new ApiDetailException("shutdown cluster failed, Caused By: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public Boolean existsByClusterId(String clusterId, Long id) {
        return ((FlinkClusterMapper)this.baseMapper).existsByClusterId(clusterId, id);
    }

    @Override
    public Boolean existsByClusterName(String clusterName, Long id) {
        return ((FlinkClusterMapper)this.baseMapper).existsByClusterName(clusterName, id);
    }

    @Override
    public Boolean existsByFlinkEnvId(Long flinkEnvId) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkCluster::getVersionId, (Object)flinkEnvId);
        return ((FlinkClusterMapper)this.getBaseMapper()).exists((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<FlinkCluster> getByExecutionModes(Collection<ExecutionMode> executionModes) {
        return ((FlinkClusterMapper)this.getBaseMapper()).selectList((Wrapper)new LambdaQueryWrapper().in(FlinkCluster::getExecutionMode, (Collection)executionModes.stream().map(ExecutionMode::getMode).collect(Collectors.toSet())));
    }

    @Override
    public void delete(FlinkCluster cluster) {
        Long id = cluster.getId();
        FlinkCluster flinkCluster = (FlinkCluster)this.getById(id);
        if (flinkCluster == null) {
            throw new ApiAlertException("flink cluster not exist, please check.");
        }
        if ((ExecutionMode.YARN_SESSION.equals((Object)flinkCluster.getExecutionModeEnum()) || ExecutionMode.KUBERNETES_NATIVE_SESSION.equals((Object)flinkCluster.getExecutionModeEnum())) && ClusterState.STARTED.equals((Object)flinkCluster.getClusterStateEnum())) {
            throw new ApiAlertException("flink cluster is running, cannot be delete, please check.");
        }
        if (this.applicationService.existsJobByClusterId(id)) {
            throw new ApiAlertException("some app on this cluster, the cluster cannot be delete, please check.");
        }
        this.removeById(id);
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(FlinkCluster clusterInfo) {
        this.yarnQueueService.checkQueueLabel(clusterInfo.getExecutionModeEnum(), clusterInfo.getYarnQueue());
        if (!this.isYarnNotDefaultQueue(clusterInfo)) {
            return true;
        }
        return this.yarnQueueService.existByQueueLabel(clusterInfo.getYarnQueue());
    }

    @VisibleForTesting
    public boolean validateQueueIfNeeded(FlinkCluster oldCluster, FlinkCluster newCluster) {
        this.yarnQueueService.checkQueueLabel(newCluster.getExecutionModeEnum(), newCluster.getYarnQueue());
        if (!this.isYarnNotDefaultQueue(newCluster)) {
            return true;
        }
        if (ExecutionMode.isYarnSessionMode((ExecutionMode)newCluster.getExecutionModeEnum()) && StringUtils.equals((CharSequence)oldCluster.getYarnQueue(), (CharSequence)newCluster.getYarnQueue())) {
            return true;
        }
        return this.yarnQueueService.existByQueueLabel(newCluster.getYarnQueue());
    }

    private boolean isYarnNotDefaultQueue(FlinkCluster cluster) {
        return ExecutionMode.isYarnSessionMode((ExecutionMode)cluster.getExecutionModeEnum()) && !this.yarnQueueService.isDefaultQueue(cluster.getYarnQueue());
    }
}

