/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.storm.messaging.netty.SaslUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaslNettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(SaslNettyServer.class);
    private SaslServer saslServer;

    SaslNettyServer(String topologyName, byte[] token) throws IOException {
        LOG.debug("SaslNettyServer: Topology token is: {} with authmethod {}", (Object)topologyName, (Object)"DIGEST-MD5");
        try {
            SaslDigestCallbackHandler ch = new SaslDigestCallbackHandler(topologyName, token);
            this.saslServer = Sasl.createSaslServer("DIGEST-MD5", null, "default", SaslUtils.getSaslProps(), ch);
        }
        catch (SaslException e) {
            LOG.error("SaslNettyServer: Could not create SaslServer: ", (Throwable)e);
        }
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getUserName() {
        return this.saslServer.getAuthorizationID();
    }

    public byte[] response(byte[] token) {
        try {
            LOG.debug("response: Responding to input token of length: {}", (Object)token.length);
            byte[] retval = this.saslServer.evaluateResponse(token);
            LOG.debug("response: Response token length: {}", (Object)retval.length);
            return retval;
        }
        catch (SaslException e) {
            LOG.error("response: Failed to evaluate client token of length: {} : {}", (Object)token.length, (Object)e);
            return null;
        }
    }

    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private byte[] userPassword;
        private String userName;

        SaslDigestCallbackHandler(String topologyName, byte[] token) {
            LOG.debug("SaslDigestCallback: Creating SaslDigestCallback handler with topology token: {}", (Object)topologyName);
            this.userName = topologyName;
            this.userPassword = token;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (nc != null) {
                LOG.debug("handle: SASL server DIGEST-MD5 callback: setting username for client: {}", (Object)this.userName);
                nc.setName(this.userName);
            }
            if (pc != null) {
                char[] password = SaslUtils.encodePassword(this.userPassword);
                LOG.debug("handle: SASL server DIGEST-MD5 callback: setting password for client: ", (Object)this.userPassword);
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    LOG.debug("handle: SASL server DIGEST-MD5 callback: setting canonicalized client ID: ", (Object)this.userName);
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

