/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minidev.json.JSONValue;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.storm.kafka.monitor.KafkaOffsetLagResult;
import org.apache.storm.kafka.monitor.KafkaPartitionOffsetLag;
import org.apache.storm.kafka.monitor.NewKafkaSpoutOffsetQuery;

public class KafkaOffsetLagUtil {
    private static final String OPTION_TOPIC_SHORT = "t";
    private static final String OPTION_TOPIC_LONG = "topics";
    private static final String OPTION_BOOTSTRAP_BROKERS_SHORT = "b";
    private static final String OPTION_BOOTSTRAP_BROKERS_LONG = "bootstrap-brokers";
    private static final String OPTION_GROUP_ID_SHORT = "g";
    private static final String OPTION_GROUP_ID_LONG = "groupid";
    private static final String OPTION_SECURITY_PROTOCOL_SHORT = "s";
    private static final String OPTION_SECURITY_PROTOCOL_LONG = "security-protocol";
    private static final String OPTION_SASL_MECHANISM_SHORT = "m";
    private static final String OPTION_SASL_MECHANISM_LONG = "sasl-mechanism";
    private static final String OPTION_CONSUMER_CONFIG_SHORT = "c";
    private static final String OPTION_CONSUMER_CONFIG_LONG = "consumer-config";

    public static void main(String[] args) {
        try {
            Options options = KafkaOffsetLagUtil.buildOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(options, args);
            if (!commandLine.hasOption(OPTION_TOPIC_LONG)) {
                KafkaOffsetLagUtil.printUsageAndExit(options, "topics is required");
            }
            String securityProtocol = commandLine.getOptionValue(OPTION_SECURITY_PROTOCOL_LONG);
            String saslMechanism = commandLine.getOptionValue(OPTION_SASL_MECHANISM_LONG);
            if (!commandLine.hasOption(OPTION_GROUP_ID_LONG) || !commandLine.hasOption(OPTION_BOOTSTRAP_BROKERS_LONG)) {
                KafkaOffsetLagUtil.printUsageAndExit(options, "groupid and bootstrap-brokers are required");
            }
            NewKafkaSpoutOffsetQuery newKafkaSpoutOffsetQuery = new NewKafkaSpoutOffsetQuery(commandLine.getOptionValue(OPTION_TOPIC_LONG), commandLine.getOptionValue(OPTION_BOOTSTRAP_BROKERS_LONG), commandLine.getOptionValue(OPTION_GROUP_ID_LONG), securityProtocol, saslMechanism, commandLine.getOptionValue(OPTION_CONSUMER_CONFIG_LONG));
            List<KafkaOffsetLagResult> results = KafkaOffsetLagUtil.getOffsetLags(newKafkaSpoutOffsetQuery);
            Map<String, Map<Integer, KafkaPartitionOffsetLag>> keyedResult = KafkaOffsetLagUtil.keyByTopicAndPartition(results);
            System.out.print(JSONValue.toJSONString(keyedResult));
        }
        catch (Exception ex) {
            System.out.print("Unable to get offset lags for kafka. Reason: ");
            ex.printStackTrace(System.out);
        }
    }

    private static Map<String, Map<Integer, KafkaPartitionOffsetLag>> keyByTopicAndPartition(List<KafkaOffsetLagResult> results) {
        HashMap<String, Map<Integer, KafkaPartitionOffsetLag>> resultKeyedByTopic = new HashMap<String, Map<Integer, KafkaPartitionOffsetLag>>();
        for (KafkaOffsetLagResult result : results) {
            String topic = result.getTopic();
            HashMap<Integer, KafkaPartitionOffsetLag> topicResultKeyedByPartition = (HashMap<Integer, KafkaPartitionOffsetLag>)resultKeyedByTopic.get(topic);
            if (topicResultKeyedByPartition == null) {
                topicResultKeyedByPartition = new HashMap<Integer, KafkaPartitionOffsetLag>();
                resultKeyedByTopic.put(topic, topicResultKeyedByPartition);
            }
            topicResultKeyedByPartition.put(result.getPartition(), new KafkaPartitionOffsetLag(result.getConsumerCommittedOffset(), result.getLogHeadOffset()));
        }
        return resultKeyedByTopic;
    }

    private static void printUsageAndExit(Options options, String message) {
        System.out.println(message);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("storm-kafka-monitor ", options);
        System.exit(1);
    }

    private static Options buildOptions() {
        Options options = new Options();
        options.addOption(OPTION_TOPIC_SHORT, OPTION_TOPIC_LONG, true, "REQUIRED Topics (comma separated list) for fetching log head and spout committed offset");
        options.addOption(OPTION_BOOTSTRAP_BROKERS_SHORT, OPTION_BOOTSTRAP_BROKERS_LONG, true, "Comma separated list of bootstrap broker hosts for new consumer/spout e.g. hostname1:9092,hostname2:9092");
        options.addOption(OPTION_GROUP_ID_SHORT, OPTION_GROUP_ID_LONG, true, "Group id of consumer");
        options.addOption(OPTION_SECURITY_PROTOCOL_SHORT, OPTION_SECURITY_PROTOCOL_LONG, true, "Security protocol to connect to kafka");
        options.addOption(OPTION_SASL_MECHANISM_SHORT, OPTION_SASL_MECHANISM_LONG, true, "Sasl mechanism to connect to kafka, default is GSSAPI");
        options.addOption(OPTION_CONSUMER_CONFIG_SHORT, OPTION_CONSUMER_CONFIG_LONG, true, "Properties file with additional Kafka consumer properties");
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KafkaOffsetLagResult> getOffsetLags(NewKafkaSpoutOffsetQuery newKafkaSpoutOffsetQuery) throws Exception {
        ArrayList<KafkaOffsetLagResult> result = new ArrayList<KafkaOffsetLagResult>();
        try (KafkaConsumer consumer = null;){
            Properties props = new Properties();
            props.put("bootstrap.servers", newKafkaSpoutOffsetQuery.getBootStrapBrokers());
            props.put("group.id", newKafkaSpoutOffsetQuery.getConsumerGroupId());
            props.put("enable.auto.commit", "false");
            props.put("session.timeout.ms", "30000");
            props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
            if (newKafkaSpoutOffsetQuery.getSecurityProtocol() != null) {
                props.put("security.protocol", newKafkaSpoutOffsetQuery.getSecurityProtocol());
            }
            if (newKafkaSpoutOffsetQuery.getSaslMechanism() != null) {
                props.put("sasl.mechanism", newKafkaSpoutOffsetQuery.getSaslMechanism());
            }
            if (newKafkaSpoutOffsetQuery.getConsumerPropertiesFileName() != null) {
                props.putAll((Map<?, ?>)Utils.loadProps((String)newKafkaSpoutOffsetQuery.getConsumerPropertiesFileName()));
            }
            ArrayList<TopicPartition> topicPartitionList = new ArrayList<TopicPartition>();
            consumer = new KafkaConsumer(props);
            for (String topic : newKafkaSpoutOffsetQuery.getTopics().split(",")) {
                List partitionInfoList = consumer.partitionsFor(topic);
                if (partitionInfoList == null) continue;
                for (PartitionInfo partitionInfo : partitionInfoList) {
                    topicPartitionList.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
                }
            }
            consumer.assign(topicPartitionList);
            for (TopicPartition topicPartition : topicPartitionList) {
                Map offsetAndMetadata = consumer.committed(Collections.singleton(topicPartition));
                long committedOffset = offsetAndMetadata != null ? ((OffsetAndMetadata)offsetAndMetadata.get(topicPartition)).offset() : -1L;
                consumer.seekToEnd(KafkaOffsetLagUtil.toArrayList(topicPartition));
                result.add(new KafkaOffsetLagResult(topicPartition.topic(), topicPartition.partition(), committedOffset, consumer.position(topicPartition)));
            }
        }
        return result;
    }

    private static Collection<TopicPartition> toArrayList(final TopicPartition tp) {
        return new ArrayList<TopicPartition>(1){
            {
                super(arg0);
                this.add(tp);
            }
        };
    }
}

