/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.AnnotationReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.ComponentPropertyParser;
import org.apache.sling.testing.mock.osgi.config.InterfaceReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.SingleElementAnnotationReflectionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import osgimock.org.apache.felix.scr.impl.inject.internal.Annotations;

@ProviderType
abstract class AbstractConfigTypeReflectionProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigTypeReflectionProvider.class);

    AbstractConfigTypeReflectionProvider() {
    }

    static AbstractConfigTypeReflectionProvider getInstance(@NotNull Class<?> configType) {
        String prefix = Annotations.getPrefix(configType);
        if (configType.isAnnotation()) {
            if (Annotations.isSingleElementAnnotation(configType)) {
                return new SingleElementAnnotationReflectionProvider(configType, prefix);
            }
            return new AnnotationReflectionProvider(configType, prefix);
        }
        return new InterfaceReflectionProvider(configType, prefix);
    }

    abstract Class<?> getConfigType();

    abstract Method[] getMethods();

    abstract String getPropertyName(@NotNull Method var1);

    boolean isValidConfigType() {
        return Arrays.stream(this.getMethods()).allMatch(method -> method.getParameterCount() == 0 && ComponentPropertyParser.isSupportedConfigTypeValueType(method.getReturnType()));
    }

    boolean addSingleDefault(@NotNull String propertyName, @NotNull Object value, @NotNull Map<String, Object> defaults) {
        Object propertyValue = this.attributeValueToPropertyValue(value);
        if (propertyValue != null) {
            defaults.put(propertyName, propertyValue);
            return true;
        }
        return false;
    }

    Map<String, Object> getDefaults(@NotNull Map<String, Object> existingValues) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        for (Method method : this.getMethods()) {
            String propertyName;
            Object value = method.getDefaultValue();
            if (value == null || existingValues.containsKey(propertyName = this.getPropertyName(method)) || this.addSingleDefault(propertyName, value, defaults)) continue;
            return Collections.emptyMap();
        }
        return defaults;
    }

    Map<String, Object> getPropertyMap(@NotNull Object config) {
        if (this.getConfigType().isInstance(config)) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (Method method : this.getMethods()) {
                Object propertyValue;
                Object value = this.invokeAttribute(method, config);
                if (value == null || (propertyValue = this.attributeValueToPropertyValue(value)) == null) continue;
                properties.put(this.getPropertyName(method), value);
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    @Nullable
    Object invokeAttribute(Method method, Object config) {
        try {
            return method.invoke(config, (Object[])null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke config type " + this.getConfigType() + " method " + method + " on object " + config, (Throwable)e);
            return null;
        }
    }

    @Nullable
    Object attributeValueToPropertyValue(@NotNull Object value) {
        Class<?> singleType;
        Class<?> valueType = value.getClass();
        Class<?> clazz = singleType = valueType.isArray() ? valueType.getComponentType() : valueType;
        if (ComponentPropertyParser.isSupportedPropertyMapValueType(singleType)) {
            return value;
        }
        if (singleType.equals(Class.class)) {
            if (valueType.isArray()) {
                return Stream.of((Class[])value).map(Class::getName).toArray(String[]::new);
            }
            return ((Class)value).getName();
        }
        if (singleType.isEnum()) {
            if (valueType.isArray()) {
                return Stream.of((Enum[])value).map(Enum::name).toArray(String[]::new);
            }
            return ((Enum)value).name();
        }
        log.warn("illegal member type {} for annotation type", singleType);
        return null;
    }
}

