/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.uri.SlingUriBuilder;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.servlets.resolver.internal.ResolverConfig;
import org.apache.sling.servlets.resolver.internal.SlingServletResolver;
import org.apache.sling.servlets.resolver.internal.bundle.BundledScriptServlet;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.resolution.ResolutionCache;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, configurationPid={"org.apache.sling.servlets.resolver.SlingServletResolver"}, property={"service.description=Sling Servlet Resolver Web Console Plugin", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=servletresolver", "felix.webconsole.title=Sling Servlet Resolver", "felix.webconsole.css=/servletresolver/res/ui/styles.css", "felix.webconsole.category=Sling"})
public class WebConsolePlugin
extends HttpServlet {
    private static final String PARAMETER_URL = "url";
    private static final String PARAMETER_METHOD = "method";
    private static final String SERVICE_USER_CONSOLE = "console";
    @Reference(target="(subServiceName=console)")
    private ServiceUserMapped consoleServiceUserMapped;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ResolutionCache resolutionCache;
    private AtomicReference<String[]> executionPaths = new AtomicReference();
    private AtomicReference<String[]> defaultExtensions = new AtomicReference();

    @Activate
    @Modified
    protected void activate(ResolverConfig config) {
        this.executionPaths.set(SlingServletResolver.getExecutionPaths(config.servletresolver_paths()));
        this.defaultExtensions.set(config.servletresolver_defaultExtensions());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getParameter(PARAMETER_URL);
        String method = request.getParameter(PARAMETER_METHOD);
        if (StringUtils.isBlank((CharSequence)method)) {
            method = "GET";
        }
        String requestURI = request.getRequestURI();
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER_CONSOLE));){
            PrintWriter pw = response.getWriter();
            RequestPathInfo requestPathInfo = WebConsolePlugin.getRequestPathInfo(url, resourceResolver);
            if (requestURI.endsWith("json")) {
                pw.println("{");
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.printJSONDecomposedURLElement(pw, requestPathInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)requestPathInfo.getResourcePath())) {
                    this.printJSONCandidatesElement(pw, resourceResolver, requestPathInfo, method);
                }
                pw.printf("  \"method\" : \"%s\"%n", StringEscapeUtils.escapeJson((String)method));
                pw.print("}");
                response.setContentType("application/json");
            } else {
                this.printHTMLInputElements(pw, url);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.printHTMLDecomposedURLElement(pw, requestPathInfo);
                }
                if (StringUtils.isNotBlank((CharSequence)requestPathInfo.getResourcePath())) {
                    Resource resource = resourceResolver.resolve(requestPathInfo.getResourcePath());
                    Collection<Resource> servlets = this.resolveServlets(resourceResolver, requestPathInfo, resource, method);
                    this.tr(pw);
                    this.tdLabel(pw, "Candidates");
                    this.tdContent(pw);
                    if (servlets == null || servlets.isEmpty()) {
                        pw.println("Could not find a suitable servlet for this request!");
                    } else {
                        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                            pw.println("The resource given by path '");
                            pw.println(ResponseUtil.escapeXml((String)resource.getPath()));
                            pw.println("' does not exist. Therefore no resource type could be determined!<br/>");
                        }
                        pw.print("Candidate servlets and scripts in order of preference for method ");
                        pw.print(ResponseUtil.escapeXml((String)method));
                        pw.println(":<br/>");
                        pw.println("<ol class='servlets'>");
                        this.outputHTMLServlets(pw, servlets.iterator());
                        pw.println("</ol>");
                    }
                    this.closeTd(pw);
                    this.closeTr(pw);
                }
                pw.println("</table>");
                pw.print("</form>");
            }
        }
        catch (LoginException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String formatArrayAsJSON(String[] array) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (String s : array) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append("\"");
            sb.append(StringEscapeUtils.escapeJson((String)s));
            sb.append("\"");
        }
        sb.append("]");
        return sb.toString();
    }

    private Map<String, List<String>> getAllowedAndDeniedServlets(Collection<Resource> servlets) {
        ArrayList<String> allowedServlets = new ArrayList<String>();
        ArrayList<String> deniedServlets = new ArrayList<String>();
        for (Resource candidateResource : servlets) {
            Servlet candidate = (Servlet)candidateResource.adaptTo(Servlet.class);
            if (candidate == null) continue;
            boolean allowed = SlingServletResolver.isPathAllowed(candidateResource.getPath(), this.executionPaths.get());
            String finalCandidate = this.getServletDetails(candidate);
            if (allowed) {
                allowedServlets.add(finalCandidate);
                continue;
            }
            deniedServlets.add(finalCandidate);
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put("allowed", allowedServlets);
        result.put("denied", deniedServlets);
        return result;
    }

    private void printJSONDecomposedURLElement(PrintWriter pw, RequestPathInfo requestPathInfo) {
        pw.println("  \"decomposedURL\" : {");
        pw.printf("    \"path\" : \"%s\",%n", StringEscapeUtils.escapeJson((String)((String)StringUtils.defaultIfEmpty((CharSequence)requestPathInfo.getResourcePath(), (CharSequence)""))));
        pw.printf("    \"extension\" : \"%s\",%n", StringEscapeUtils.escapeJson((String)((String)StringUtils.defaultIfEmpty((CharSequence)requestPathInfo.getExtension(), (CharSequence)""))));
        pw.printf("    \"selectors\" : %s,%n", StringUtils.defaultIfEmpty((CharSequence)this.formatArrayAsJSON(requestPathInfo.getSelectors()), (CharSequence)""));
        pw.printf("    \"suffix\" : \"%s\"%n", StringEscapeUtils.escapeJson((String)((String)StringUtils.defaultIfEmpty((CharSequence)requestPathInfo.getSuffix(), (CharSequence)""))));
        pw.println("  },");
    }

    private void printJSONCandidatesElement(PrintWriter pw, ResourceResolver resourceResolver, RequestPathInfo requestPathInfo, String method) {
        Resource resource = resourceResolver.resolve(requestPathInfo.getResourcePath());
        Collection<Resource> servlets = this.resolveServlets(resourceResolver, requestPathInfo, resource, method);
        pw.println("  \"candidates\" : {");
        if (servlets != null) {
            if (ResourceUtil.isNonExistingResource((Resource)resource)) {
                pw.printf("    \"errorMsg\" : \"%s\",%n", String.format("The resource given by path '%s' does not exist. Therefore no resource type could be determined!", StringEscapeUtils.escapeJson((String)resource.getPath())));
            }
            Map<String, List<String>> allowedAndDeniedServlets = this.getAllowedAndDeniedServlets(servlets);
            List allowedServlets = allowedAndDeniedServlets.getOrDefault("allowed", new ArrayList());
            List deniedServlets = allowedAndDeniedServlets.getOrDefault("denied", new ArrayList());
            pw.printf("    \"allowedServlets\" : %s,%n", this.formatArrayAsJSON(allowedServlets.toArray(new String[0])));
            pw.printf("    \"deniedServlets\" : %s%n", this.formatArrayAsJSON(deniedServlets.toArray(new String[0])));
        }
        pw.print("  },");
    }

    private void printHTMLInputElements(PrintWriter pw, String url) {
        pw.print("<form method='get'>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        this.titleHtml(pw, "Servlet Resolver Test", "To check which servlet is responsible for rendering a response, enter a request path into the field and click 'Resolve' to resolve it.");
        this.tr(pw);
        this.tdLabel(pw, "URL");
        this.tdContent(pw);
        pw.print("<input type='text' name='");
        pw.print(PARAMETER_URL);
        pw.print("' value='");
        if (url != null) {
            pw.print(ResponseUtil.escapeXml((String)url));
        }
        pw.println("' class='input' size='50'>");
        this.closeTd(pw);
        this.closeTr(pw);
        this.closeTr(pw);
        this.tr(pw);
        this.tdLabel(pw, "Method");
        this.tdContent(pw);
        pw.print("<select name='");
        pw.print(PARAMETER_METHOD);
        pw.println("'>");
        pw.println("<option value='GET'>GET</option>");
        pw.println("<option value='POST'>POST</option>");
        pw.println("</select>");
        pw.println("&nbsp;&nbsp;<input type='submit' value='Resolve' class='submit'>");
        this.closeTd(pw);
        this.closeTr(pw);
    }

    private void printHTMLDecomposedURLElement(PrintWriter pw, RequestPathInfo requestPathInfo) {
        this.tr(pw);
        this.tdLabel(pw, "Decomposed URL");
        this.tdContent(pw);
        pw.println("<dl>");
        pw.println("<dt>Path</dt>");
        this.dd(pw);
        pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getResourcePath()));
        this.closeDd(pw);
        pw.println("<dt>Selectors</dt>");
        this.dd(pw);
        if (requestPathInfo.getSelectors().length == 0) {
            pw.print("&lt;none&gt;");
        } else {
            pw.print("[");
            pw.print(ResponseUtil.escapeXml((String)StringUtils.join((Object[])requestPathInfo.getSelectors(), (String)", ")));
            pw.print("]");
        }
        this.closeDd(pw);
        pw.println("<dt>Extension</dt>");
        this.dd(pw);
        pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getExtension()));
        this.closeDd(pw);
        pw.println("</dl>");
        this.closeDd(pw);
        pw.println("<dt>Suffix</dt>");
        this.dd(pw);
        pw.print(ResponseUtil.escapeXml((String)requestPathInfo.getSuffix()));
        this.closeDd(pw);
        pw.println("</dl>");
        this.closeTd(pw);
        this.closeTr(pw);
    }

    private Collection<Resource> resolveServlets(ResourceResolver resourceResolver, RequestPathInfo requestPathInfo, Resource resource, String method) {
        Collection<Resource> servlets;
        if (resource.adaptTo(Servlet.class) != null) {
            servlets = Collections.singleton(resource);
        } else {
            ResourceCollector locationUtil = ResourceCollector.create(resource, requestPathInfo.getExtension(), this.executionPaths.get(), this.defaultExtensions.get(), method, requestPathInfo.getSelectors(), true);
            servlets = locationUtil.getServlets(resourceResolver, this.resolutionCache.getScriptEngineExtensions());
        }
        return servlets;
    }

    private void tdContent(PrintWriter pw) {
        pw.print("<td class='content' colspan='2'>");
    }

    private void closeTd(PrintWriter pw) {
        pw.print("</td>");
    }

    private void dd(PrintWriter pw) {
        pw.println("<dd>");
    }

    private void closeDd(PrintWriter pw) {
        pw.print("</dd>");
    }

    private URL getResource(String path) {
        if (path.startsWith("/servletresolver/res/ui")) {
            return ((Object)((Object)this)).getClass().getResource(path.substring(16));
        }
        return null;
    }

    private void closeTr(PrintWriter pw) {
        pw.println("</tr>");
    }

    private void tdLabel(PrintWriter pw, String label) {
        pw.print("<td class='content'>");
        pw.print(ResponseUtil.escapeXml((String)label));
        pw.println("</td>");
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr class='content'>");
    }

    private void outputHTMLServlets(PrintWriter pw, Iterator<Resource> iterator) {
        while (iterator.hasNext()) {
            Resource candidateResource = iterator.next();
            Servlet candidate = (Servlet)candidateResource.adaptTo(Servlet.class);
            if (candidate == null) continue;
            boolean allowed = SlingServletResolver.isPathAllowed(candidateResource.getPath(), this.executionPaths.get());
            pw.print("<li>");
            String candidateStr = this.getServletDetails(candidate);
            if (!allowed) {
                pw.print("<del>" + candidateStr + "</del>");
            } else {
                pw.print(candidateStr);
            }
            pw.println("</li>");
        }
    }

    private String getServletDetails(Servlet servlet) {
        StringBuilder details = new StringBuilder();
        if (servlet instanceof SlingScript) {
            SlingScript script = (SlingScript)SlingScript.class.cast(servlet);
            details.append(ResponseUtil.escapeXml((String)script.getScriptResource().getPath()));
            details.append(" (Resource Script)");
        } else {
            Bundle bundle;
            if (servlet instanceof BundledScriptServlet) {
                BundledScriptServlet script = (BundledScriptServlet)((Object)BundledScriptServlet.class.cast(servlet));
                bundle = script.getBundledRenderUnit().getBundle();
                details.append(ResponseUtil.escapeXml((String)script.getBundledRenderUnit().getName()));
                details.append(" (Bundled Script)");
            } else {
                boolean isOptingServlet = servlet instanceof OptingServlet;
                details.append(ResponseUtil.escapeXml((String)servlet.getClass().getName()));
                if (isOptingServlet) {
                    details.append(" (OptingServlet)");
                } else {
                    details.append(" (Servlet)");
                }
                bundle = FrameworkUtil.getBundle(servlet.getClass());
            }
            if (bundle != null) {
                details.append(" in bundle '").append(bundle.getSymbolicName()).append("' (").append(bundle.getBundleId()).append(")");
            }
        }
        return details.toString();
    }

    private void titleHtml(PrintWriter pw, String title, String description) {
        this.tr(pw);
        pw.print("<th colspan='3' class='content container'>");
        pw.print(ResponseUtil.escapeXml((String)title));
        pw.println("</th>");
        this.closeTr(pw);
        if (description != null) {
            this.tr(pw);
            pw.print("<td colspan='3' class='content'>");
            pw.print(ResponseUtil.escapeXml((String)description));
            pw.println("</th>");
            this.closeTr(pw);
        }
    }

    static RequestPathInfo getRequestPathInfo(String urlString, ResourceResolver resourceResolver) {
        if (urlString == null) {
            urlString = "";
        }
        String fullPath = urlString;
        if (urlString.contains("http")) {
            try {
                fullPath = new URL(urlString).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return SlingUriBuilder.create().setResourceResolver(resourceResolver).setPath(fullPath).build();
    }
}

