/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.FeatureDescriptor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface AnalyserResult {
    default public List<String> getWarnings() {
        return Stream.of(this.getGlobalWarnings().stream().map(GlobalReport::toString), this.getArtifactWarnings().stream().map(Report::toString), this.getExtensionWarnings().stream().map(Report::toString), this.getConfigurationWarnings().stream().map(Report::toString)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<GlobalReport> getGlobalWarnings();

    public List<ArtifactReport> getArtifactWarnings();

    public List<ExtensionReport> getExtensionWarnings();

    public List<ConfigurationReport> getConfigurationWarnings();

    default public List<String> getErrors() {
        return Stream.of(this.getGlobalErrors().stream().map(Report::toString), this.getArtifactErrors().stream().map(Report::toString), this.getExtensionErrors().stream().map(Report::toString), this.getConfigurationErrors().stream().map(Report::toString)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<GlobalReport> getGlobalErrors();

    public List<ArtifactReport> getArtifactErrors();

    public List<ExtensionReport> getExtensionErrors();

    public List<ConfigurationReport> getConfigurationErrors();

    public FeatureDescriptor getFeatureDescriptor();

    public BundleDescriptor getFrameworkDescriptor();

    public static class GlobalReport
    extends Report<Void> {
        GlobalReport(String value, String taskId) {
            super(null, value, taskId);
        }

        @Override
        public String toString() {
            return "[".concat(this.getTaskId()).concat("] ").concat(this.getValue());
        }
    }

    public static class ExtensionReport
    extends Report<String> {
        ExtensionReport(String key, String value, String taskId) {
            super(key, value, taskId);
        }
    }

    public static class ArtifactReport
    extends Report<ArtifactId> {
        ArtifactReport(ArtifactId key, String value, String taskId) {
            super(key, value, taskId);
        }
    }

    public static class ConfigurationReport
    extends Report<Configuration> {
        ConfigurationReport(Configuration key, String value, String taskId) {
            super(key, value, taskId);
        }

        @Override
        public String toString() {
            return "[".concat(this.getTaskId()).concat("] Configuration ").concat(((Configuration)this.getKey()).getPid()).concat(": ").concat(this.getValue());
        }
    }

    public static class Report<T> {
        private final T key;
        private final String value;
        private final String taskId;

        Report(T key, String value, String taskId) {
            this.key = key;
            this.value = value;
            this.taskId = taskId;
        }

        public T getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String toString() {
            return "[".concat(this.getTaskId()).concat("] ").concat(this.getKey().toString()).concat(": ").concat(this.getValue());
        }
    }
}

