/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public abstract class ServerBehaviourDelegateWithModulePublishSupport
extends ServerBehaviourDelegate {
    private IAdaptable info3;
    private List<IModule[]> modules3;

    public void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.info3 = info;
        this.modules3 = modules == null ? null : new LinkedList<IModule[]>(modules);
        super.publish(kind, modules, monitor, info);
    }

    private List<Integer> computeDelta(List<IModule[]> moduleList) {
        ArrayList<Integer> deltaKindList = new ArrayList<Integer>();
        for (IModule[] module : moduleList) {
            if (this.hasBeenPublished(module)) {
                IModule m = module[module.length - 1];
                if (m.getProject() != null && !m.getProject().isAccessible() || this.getPublishedResourceDelta(module).length == 0) {
                    deltaKindList.add(new Integer(0));
                    continue;
                }
                deltaKindList.add(new Integer(2));
                continue;
            }
            deltaKindList.add(new Integer(1));
        }
        return deltaKindList;
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        MultiStatus tempMulti;
        block52: {
            block50: {
                List<Integer> deltaKindList;
                List<Object> moduleList;
                block49: {
                    String mainTaskMsg;
                    block48: {
                        PublishOperation[] tasks;
                        block47: {
                            Activator.getDefault().getPluginLogger().trace("-->-- Publishing to server: " + this.getServer().toString() + " -->--", new Object[0]);
                            if (this.getServer().getServerType().hasRuntime() && this.getServer().getRuntime() == null) {
                                return new Status(4, "org.apache.sling.ide.eclipse-core", 0, "No runtime available", null);
                            }
                            moduleList = this.modules3 == null ? this.getAllModules() : new LinkedList<IModule[]>(this.modules3);
                            deltaKindList = this.computeDelta((List<IModule[]>)moduleList);
                            tasks = this.getTasks(kind, moduleList, deltaKindList);
                            int size = 2000 + 3500 * moduleList.size() + 500 * tasks.length;
                            mainTaskMsg = "Publishing to " + this.getServer().getName();
                            monitor.beginTask(mainTaskMsg, size);
                            tempMulti = new MultiStatus("org.apache.sling.ide.eclipse-core", 0, "", null);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            Activator.getDefault().getPluginLogger().trace("Starting publish", new Object[0]);
                            this.publishStart(monitor);
                            if (!monitor.isCanceled()) break block47;
                            IStatus iStatus = Status.CANCEL_STATUS;
                            try {
                                this.publishFinish(monitor);
                            }
                            catch (CoreException ce) {
                                Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                                tempMulti.add(ce.getStatus());
                            }
                            catch (Exception e) {
                                Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                                tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                            }
                            return iStatus;
                        }
                        MultiStatus taskStatus = this.performTasks(tasks, monitor);
                        monitor.setTaskName(mainTaskMsg);
                        if (taskStatus != null && !taskStatus.isOK()) {
                            tempMulti.addAll((IStatus)taskStatus);
                        }
                        taskStatus = this.executePublishers(kind, moduleList, deltaKindList, monitor, this.info3);
                        monitor.setTaskName(mainTaskMsg);
                        if (taskStatus != null && !taskStatus.isOK()) {
                            tempMulti.addAll((IStatus)taskStatus);
                        }
                        if (!monitor.isCanceled()) break block48;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        try {
                            this.publishFinish(monitor);
                        }
                        catch (CoreException ce) {
                            Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                            tempMulti.add(ce.getStatus());
                        }
                        catch (Exception e) {
                            Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                            tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                        }
                        return iStatus;
                    }
                    this.publishServer(kind, monitor);
                    monitor.setTaskName(mainTaskMsg);
                    if (!monitor.isCanceled()) break block49;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    try {
                        this.publishFinish(monitor);
                    }
                    catch (CoreException ce) {
                        Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                        tempMulti.add(ce.getStatus());
                    }
                    catch (Exception e) {
                        Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                        tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                    }
                    return iStatus;
                }
                this.publishModules(kind, moduleList, deltaKindList, tempMulti, monitor);
                if (!monitor.isCanceled()) break block50;
                IStatus iStatus = Status.CANCEL_STATUS;
                try {
                    this.publishFinish(monitor);
                }
                catch (CoreException ce) {
                    Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                    tempMulti.add(ce.getStatus());
                }
                catch (Exception e) {
                    Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                    tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                }
                return iStatus;
            }
            try {
                monitor.done();
            }
            catch (CoreException ce) {
                Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                IStatus iStatus = ce.getStatus();
                try {
                    this.publishFinish(monitor);
                }
                catch (CoreException ce2) {
                    Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce2);
                    tempMulti.add(ce2.getStatus());
                }
                catch (Exception e) {
                    Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                    tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                }
                return iStatus;
            }
            catch (Exception e) {
                try {
                    Activator.getDefault().getPluginLogger().error("Error publishing  to " + ((Object)((Object)this)).toString(), (Throwable)e);
                    tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
                    break block52;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.publishFinish(monitor);
                    }
                    catch (CoreException ce) {
                        Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                        tempMulti.add(ce.getStatus());
                    }
                    catch (Exception e2) {
                        Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e2);
                        tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e2));
                    }
                }
            }
            try {
                this.publishFinish(monitor);
            }
            catch (CoreException ce) {
                Activator.getDefault().getPluginLogger().error("CoreException publishing to " + ((Object)((Object)this)).toString(), (Throwable)ce);
                tempMulti.add(ce.getStatus());
            }
            catch (Exception e) {
                Activator.getDefault().getPluginLogger().error("Error stopping publish to " + ((Object)((Object)this)).toString(), (Throwable)e);
                tempMulti.add((IStatus)new Status(4, "org.apache.sling.ide.eclipse-core", 0, "Error publishing", (Throwable)e));
            }
        }
        Activator.getDefault().getPluginLogger().trace("--<-- Done publishing --<--", new Object[0]);
        if (tempMulti.getChildren().length == 1) {
            return tempMulti.getChildren()[0];
        }
        MultiStatus multi = null;
        if (tempMulti.getSeverity() == 0) {
            return Status.OK_STATUS;
        }
        if (tempMulti.getSeverity() == 1) {
            multi = new MultiStatus("org.apache.sling.ide.eclipse-core", 0, "Publishing completed with information", null);
        } else if (tempMulti.getSeverity() == 2) {
            multi = new MultiStatus("org.apache.sling.ide.eclipse-core", 0, "Publishing completed with a warning", null);
        } else if (tempMulti.getSeverity() == 4) {
            multi = new MultiStatus("org.apache.sling.ide.eclipse-core", 0, "Publishing failed", null);
        }
        if (multi != null) {
            multi.addAll((IStatus)tempMulti);
        }
        return multi;
    }
}

