/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.KillStatement;

public final class KillProcessExecutor
implements DatabaseAdminExecutor {
    private static final String QUERY_SCOPE = "QUERY";
    private final KillStatement killStatement;

    public void execute(ConnectionSession connectionSession) throws SQLException {
        ShardingSpherePreconditions.checkState((boolean)QUERY_SCOPE.equalsIgnoreCase(this.killStatement.getScope()), () -> new UnsupportedSQLOperationException("Only `KILL QUERY <processId>` SQL syntax is supported"));
        String processId = this.killStatement.getProcessId();
        ProxyContext.getInstance().getContextManager().getPersistServiceFacade().getProcessPersistService().killProcess(processId);
    }

    @Generated
    public KillProcessExecutor(KillStatement killStatement) {
        this.killStatement = killStatement;
    }
}

