/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.dml;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.combine.CombineSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.TableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.lock.LockSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.order.GroupBySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.order.OrderBySegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.predicate.HavingSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.predicate.WhereSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.projection.ProjectionsSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.with.WithSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SelectStatementBinder
implements SQLStatementBinder<SelectStatement> {
    private final Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts;

    public SelectStatementBinder() {
        this.outerTableBinderContexts = LinkedHashMultimap.create();
    }

    @Override
    public SelectStatement bind(SelectStatement sqlStatement, SQLStatementBinderContext binderContext) {
        SelectStatement result = this.copy(sqlStatement);
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        sqlStatement.getWithSegment().ifPresent(optional -> result.setWithSegment(WithSegmentBinder.bind(optional, binderContext, binderContext.getExternalTableBinderContexts())));
        Optional<TableSegment> boundTableSegment = sqlStatement.getFrom().map(arg_0 -> this.lambda$bind$1(binderContext, (Multimap)tableBinderContexts, arg_0));
        boundTableSegment.ifPresent(arg_0 -> ((SelectStatement)result).setFrom(arg_0));
        result.setProjections(ProjectionsSegmentBinder.bind(sqlStatement.getProjections(), binderContext, (TableSegment)boundTableSegment.orElse(null), (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts));
        sqlStatement.getWhere().ifPresent(arg_0 -> this.lambda$bind$2(result, binderContext, (Multimap)tableBinderContexts, arg_0));
        sqlStatement.getCombine().ifPresent(optional -> result.setCombine(CombineSegmentBinder.bind(optional, binderContext, this.outerTableBinderContexts)));
        sqlStatement.getLock().ifPresent(arg_0 -> this.lambda$bind$4(result, binderContext, (Multimap)tableBinderContexts, arg_0));
        Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts = this.createCurrentTableBinderContexts(binderContext, result);
        sqlStatement.getGroupBy().ifPresent(arg_0 -> this.lambda$bind$5(result, binderContext, currentTableBinderContexts, (Multimap)tableBinderContexts, arg_0));
        sqlStatement.getOrderBy().ifPresent(arg_0 -> this.lambda$bind$6(result, binderContext, currentTableBinderContexts, (Multimap)tableBinderContexts, arg_0));
        sqlStatement.getHaving().ifPresent(optional -> result.setHaving(HavingSegmentBinder.bind(optional, binderContext, currentTableBinderContexts, this.outerTableBinderContexts)));
        return result;
    }

    private Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> createCurrentTableBinderContexts(SQLStatementBinderContext binderContext, SelectStatement selectStatement) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        Collection<ProjectionSegment> subqueryProjections = SubqueryTableBindUtils.createSubqueryProjections(selectStatement.getProjections().getProjections(), new IdentifierValue(""), binderContext.getSqlStatement().getDatabaseType());
        result.put((Object)new CaseInsensitiveMap.CaseInsensitiveString(""), (Object)new SimpleTableSegmentBinderContext(subqueryProjections));
        return result;
    }

    private SelectStatement copy(SelectStatement sqlStatement) {
        SelectStatement result = (SelectStatement)sqlStatement.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        sqlStatement.getLimit().ifPresent(arg_0 -> ((SelectStatement)result).setLimit(arg_0));
        sqlStatement.getWindow().ifPresent(arg_0 -> ((SelectStatement)result).setWindow(arg_0));
        sqlStatement.getModelSegment().ifPresent(arg_0 -> ((SelectStatement)result).setModelSegment(arg_0));
        sqlStatement.getSubqueryType().ifPresent(arg_0 -> ((SelectStatement)result).setSubqueryType(arg_0));
        result.addParameterMarkerSegments(sqlStatement.getParameterMarkerSegments());
        result.getCommentSegments().addAll(sqlStatement.getCommentSegments());
        result.getVariableNames().addAll(sqlStatement.getVariableNames());
        return result;
    }

    @Generated
    public SelectStatementBinder(Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        this.outerTableBinderContexts = outerTableBinderContexts;
    }

    private /* synthetic */ void lambda$bind$6(SelectStatement result, SQLStatementBinderContext binderContext, Multimap currentTableBinderContexts, Multimap tableBinderContexts, OrderBySegment optional) {
        result.setOrderBy(OrderBySegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts));
    }

    private /* synthetic */ void lambda$bind$5(SelectStatement result, SQLStatementBinderContext binderContext, Multimap currentTableBinderContexts, Multimap tableBinderContexts, GroupBySegment optional) {
        result.setGroupBy(GroupBySegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)currentTableBinderContexts, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts));
    }

    private /* synthetic */ void lambda$bind$4(SelectStatement result, SQLStatementBinderContext binderContext, Multimap tableBinderContexts, LockSegment optional) {
        result.setLock(LockSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts));
    }

    private /* synthetic */ void lambda$bind$2(SelectStatement result, SQLStatementBinderContext binderContext, Multimap tableBinderContexts, WhereSegment optional) {
        result.setWhere(WhereSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts));
    }

    private /* synthetic */ TableSegment lambda$bind$1(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, TableSegment optional) {
        return TableSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts, this.outerTableBinderContexts);
    }
}

