/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowAlgorithmNameRule;
import org.apache.shardingsphere.shadow.rule.ShadowDataSourceRule;
import org.apache.shardingsphere.shadow.rule.ShadowTableRule;
import org.apache.shardingsphere.shadow.rule.attribute.ShadowDataSourceMapperRuleAttribute;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.hint.HintShadowAlgorithm;

public final class ShadowRule
implements DatabaseRule {
    private final ShadowRuleConfiguration configuration;
    private final Map<String, ShadowAlgorithm> shadowAlgorithms;
    private final ShadowAlgorithm defaultShadowAlgorithm;
    private final Map<String, ShadowDataSourceRule> dataSourceRules;
    private final Map<String, ShadowTableRule> tableRules;
    private final RuleAttributes attributes;

    public ShadowRule(ShadowRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.shadowAlgorithms = this.createShadowAlgorithms(ruleConfig.getShadowAlgorithms());
        this.defaultShadowAlgorithm = this.shadowAlgorithms.get(ruleConfig.getDefaultShadowAlgorithmName());
        this.dataSourceRules = this.createDataSourceRules(ruleConfig.getDataSources());
        this.tableRules = this.createTableRules(ruleConfig.getTables());
        this.attributes = new RuleAttributes(new RuleAttribute[]{new ShadowDataSourceMapperRuleAttribute(this.dataSourceRules)});
    }

    private Map<String, ShadowAlgorithm> createShadowAlgorithms(Map<String, AlgorithmConfiguration> shadowAlgorithmConfigs) {
        return shadowAlgorithmConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (ShadowAlgorithm)TypedSPILoader.getService(ShadowAlgorithm.class, (Object)((AlgorithmConfiguration)entry.getValue()).getType(), (Properties)((AlgorithmConfiguration)entry.getValue()).getProps()), (a, b) -> b, LinkedHashMap::new));
    }

    private Map<String, ShadowDataSourceRule> createDataSourceRules(Collection<ShadowDataSourceConfiguration> dataSourceConfigs) {
        return (Map)dataSourceConfigs.stream().collect(Collectors.toMap(ShadowDataSourceConfiguration::getName, each -> new ShadowDataSourceRule(each.getProductionDataSourceName(), each.getShadowDataSourceName()), (a, b) -> b, CaseInsensitiveMap::new));
    }

    private Map<String, ShadowTableRule> createTableRules(Map<String, ShadowTableConfiguration> tableConfigs) {
        return (Map)tableConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ShadowTableRule((String)entry.getKey(), ((ShadowTableConfiguration)entry.getValue()).getDataSourceNames(), ((ShadowTableConfiguration)entry.getValue()).getShadowAlgorithmNames(), this.shadowAlgorithms), (a, b) -> b, CaseInsensitiveMap::new));
    }

    public boolean containsShadowAlgorithm(String algorithmName) {
        return this.shadowAlgorithms.containsKey(algorithmName);
    }

    public Optional<ShadowAlgorithm> getDefaultShadowAlgorithm() {
        return Optional.ofNullable(this.defaultShadowAlgorithm);
    }

    public Collection<String> filterShadowTables(Collection<String> tableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : tableNames) {
            if (!this.tableRules.containsKey(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getAllShadowTableNames() {
        return this.tableRules.keySet();
    }

    public Collection<HintShadowAlgorithm<Comparable<?>>> getAllHintShadowAlgorithms() {
        LinkedList result = new LinkedList();
        for (Map.Entry<String, ShadowAlgorithm> entry : this.shadowAlgorithms.entrySet()) {
            if (!(entry.getValue() instanceof HintShadowAlgorithm)) continue;
            result.add((HintShadowAlgorithm)entry.getValue());
        }
        return result;
    }

    public Collection<HintShadowAlgorithm<Comparable<?>>> getHintShadowAlgorithms(String tableName) {
        LinkedList result = new LinkedList();
        for (String each : this.tableRules.get(tableName).getHintShadowAlgorithmNames()) {
            result.add((HintShadowAlgorithm)this.shadowAlgorithms.get(each));
        }
        return result;
    }

    public Collection<ColumnShadowAlgorithm<Comparable<?>>> getColumnShadowAlgorithms(ShadowOperationType operationType, String tableName, String shadowColumnName) {
        LinkedList result = new LinkedList();
        for (ShadowAlgorithmNameRule each : (Collection)this.tableRules.get(tableName).getColumnShadowAlgorithmNames().getOrDefault(operationType, Collections.emptyList())) {
            if (!shadowColumnName.equals(each.getShadowColumnName())) continue;
            result.add((ColumnShadowAlgorithm)this.shadowAlgorithms.get(each.getShadowAlgorithmName()));
        }
        return result;
    }

    public Collection<String> getShadowColumnNames(ShadowOperationType operationType, String tableName) {
        LinkedList<String> result = new LinkedList<String>();
        for (ShadowAlgorithmNameRule each : (Collection)this.tableRules.get(tableName).getColumnShadowAlgorithmNames().getOrDefault(operationType, Collections.emptyList())) {
            result.add(each.getShadowColumnName());
        }
        return result;
    }

    public Map<String, String> getShadowDataSourceMappings(String tableName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        for (String each : this.tableRules.get(tableName).getLogicDataSourceNames()) {
            ShadowDataSourceRule dataSourceRule = this.dataSourceRules.get(each);
            result.put(dataSourceRule.getProductionDataSource(), dataSourceRule.getShadowDataSource());
        }
        return result;
    }

    public Map<String, String> getAllShadowDataSourceMappings() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.dataSourceRules.size(), 1.0f);
        for (Map.Entry<String, ShadowDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            ShadowDataSourceRule dataSourceRule = entry.getValue();
            result.put(dataSourceRule.getProductionDataSource(), dataSourceRule.getShadowDataSource());
        }
        return result;
    }

    public Optional<String> findProductionDataSourceName(String logicDataSourceName) {
        ShadowDataSourceRule dataSourceRule = this.dataSourceRules.get(logicDataSourceName);
        return null == dataSourceRule ? Optional.empty() : Optional.of(dataSourceRule.getProductionDataSource());
    }

    public int getOrder() {
        return 55;
    }

    @Generated
    public ShadowRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

