/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.api;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJob;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJobId;
import org.apache.shardingsphere.data.pipeline.cdc.CDCJobType;
import org.apache.shardingsphere.data.pipeline.cdc.api.StreamDataParameter;
import org.apache.shardingsphere.data.pipeline.cdc.config.CDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.yaml.config.YamlCDCJobConfiguration;
import org.apache.shardingsphere.data.pipeline.cdc.config.yaml.swapper.YamlCDCJobConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.cdc.constant.CDCSinkType;
import org.apache.shardingsphere.data.pipeline.cdc.core.pojo.CDCJobItemInfo;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLineConvertUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.core.datasource.yaml.swapper.YamlPipelineDataSourceConfigurationSwapper;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PipelineJobCreationWithInvalidShardingCountException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.importer.sink.PipelineSink;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.DumperCommonContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJob;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.api.TransmissionJobAPI;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobId;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.pojo.TransmissionJobItemInfo;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.PipelineGovernanceFacade;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.util.datetime.DateTimeFormatterFactory;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDCJobAPI
implements TransmissionJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CDCJobAPI.class);
    private final CDCJobType jobType = new CDCJobType();
    private final PipelineJobManager jobManager = new PipelineJobManager((PipelineJobType)this.jobType);
    private final PipelineJobConfigurationManager jobConfigManager = new PipelineJobConfigurationManager((PipelineJobType)this.jobType);
    private final YamlDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlDataSourceConfigurationSwapper();
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlPipelineDataSourceConfigurationSwapper pipelineDataSourceConfigSwapper = new YamlPipelineDataSourceConfigurationSwapper();

    public String create(StreamDataParameter param, CDCSinkType sinkType, Properties sinkProps) {
        PipelineContextKey contextKey = new PipelineContextKey(param.getDatabaseName(), InstanceType.PROXY);
        YamlCDCJobConfiguration yamlJobConfig = this.getYamlCDCJobConfiguration(param, sinkType, sinkProps, contextKey);
        CDCJobConfiguration jobConfig = new YamlCDCJobConfigurationSwapper().swapToObject(yamlJobConfig);
        ShardingSpherePreconditions.checkState((0 != jobConfig.getJobShardingCount() ? 1 : 0) != 0, () -> new PipelineJobCreationWithInvalidShardingCountException(jobConfig.getJobId()));
        PipelineGovernanceFacade governanceFacade = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfig.getJobId()));
        if (governanceFacade.getJobFacade().getConfiguration().isExisted(jobConfig.getJobId())) {
            log.warn("CDC job already exists in registry center, ignore, job id is `{}`", (Object)jobConfig.getJobId());
        } else {
            governanceFacade.getJobFacade().getJob().create(jobConfig.getJobId(), this.jobType.getJobClass());
            JobConfigurationPOJO jobConfigPOJO = this.jobConfigManager.convertToJobConfigurationPOJO((PipelineJobConfiguration)jobConfig);
            jobConfigPOJO.setDisabled(true);
            governanceFacade.getJobFacade().getConfiguration().persist(jobConfig.getJobId(), jobConfigPOJO);
            if (!param.isFull()) {
                this.initIncrementalPosition(jobConfig);
            }
        }
        return jobConfig.getJobId();
    }

    private YamlCDCJobConfiguration getYamlCDCJobConfiguration(StreamDataParameter param, CDCSinkType sinkType, Properties sinkProps, PipelineContextKey contextKey) {
        YamlCDCJobConfiguration result = new YamlCDCJobConfiguration();
        List<String> schemaTableNames = param.getSchemaTableNames();
        Collections.sort(schemaTableNames);
        result.setJobId(PipelineJobIdUtils.marshal((PipelineJobId)new CDCJobId(contextKey, schemaTableNames, param.isFull(), sinkType)));
        result.setDatabaseName(param.getDatabaseName());
        result.setSchemaTableNames(schemaTableNames);
        result.setFull(param.isFull());
        result.setDecodeWithTX(param.isDecodeWithTX());
        YamlCDCJobConfiguration.YamlSinkConfiguration sinkConfig = new YamlCDCJobConfiguration.YamlSinkConfiguration();
        sinkConfig.setSinkType(sinkType.name());
        sinkConfig.setProps(sinkProps);
        result.setSinkConfig(sinkConfig);
        ShardingSphereDatabase database = PipelineContextManager.getContext((PipelineContextKey)contextKey).getContextManager().getMetaDataContexts().getMetaData().getDatabase(param.getDatabaseName());
        result.setDataSourceConfiguration(this.pipelineDataSourceConfigSwapper.swapToYamlConfiguration((PipelineDataSourceConfiguration)this.getDataSourceConfiguration(database)));
        List jobDataNodeLines = JobDataNodeLineConvertUtils.convertDataNodesToLines(param.getDataNodesMap());
        result.setJobShardingDataNodes(jobDataNodeLines.stream().map(JobDataNodeLine::marshal).collect(Collectors.toList()));
        JobDataNodeLine tableFirstDataNodes = new JobDataNodeLine(param.getDataNodesMap().entrySet().stream().map(each -> new JobDataNodeEntry((String)each.getKey(), ((List)each.getValue()).subList(0, 1))).collect(Collectors.toList()));
        result.setTablesFirstDataNodes(tableFirstDataNodes.marshal());
        result.setSourceDatabaseType(PipelineDataSourceConfigurationFactory.newInstance((String)result.getDataSourceConfiguration().getType(), (String)result.getDataSourceConfiguration().getParameter()).getDatabaseType().getType());
        return result;
    }

    private ShardingSpherePipelineDataSourceConfiguration getDataSourceConfiguration(ShardingSphereDatabase database) {
        HashMap<String, Map> dataSourcePoolProps = new HashMap<String, Map>(database.getResourceMetaData().getStorageUnits().size(), 1.0f);
        for (Map.Entry entry : database.getResourceMetaData().getStorageUnits().entrySet()) {
            dataSourcePoolProps.put((String)entry.getKey(), this.dataSourceConfigSwapper.swapToMap(((StorageUnit)entry.getValue()).getDataSourcePoolProperties()));
        }
        YamlRootConfiguration targetRootConfig = new YamlRootConfiguration();
        targetRootConfig.setDatabaseName(database.getName());
        targetRootConfig.setDataSources(dataSourcePoolProps);
        targetRootConfig.setRules(this.ruleConfigSwapperEngine.swapToYamlRuleConfigurations(database.getRuleMetaData().getConfigurations()));
        return new ShardingSpherePipelineDataSourceConfiguration(targetRootConfig);
    }

    private void initIncrementalPosition(CDCJobConfiguration jobConfig) {
        String jobId = jobConfig.getJobId();
        PipelineJobItemManager jobItemManager = new PipelineJobItemManager((YamlPipelineJobItemProgressSwapper)this.jobType.getYamlJobItemProgressSwapper());
        try (PipelineDataSourceManager pipelineDataSourceManager = new PipelineDataSourceManager();){
            for (int i = 0; i < jobConfig.getJobShardingCount(); ++i) {
                if (jobItemManager.getProgress(jobId, i).isPresent()) continue;
                IncrementalDumperContext dumperContext = this.buildDumperContext(jobConfig, i, new TableAndSchemaNameMapper(jobConfig.getSchemaTableNames()));
                TransmissionJobItemProgress jobItemProgress = this.getTransmissionJobItemProgress(jobConfig, pipelineDataSourceManager, dumperContext);
                PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobItemFacade().getProcess().persist(jobId, i, YamlEngine.marshal((Object)this.jobType.getYamlJobItemProgressSwapper().swapToYamlConfiguration(jobItemProgress)));
            }
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobId, ex);
        }
    }

    private IncrementalDumperContext buildDumperContext(CDCJobConfiguration jobConfig, int jobShardingItem, TableAndSchemaNameMapper tableAndSchemaNameMapper) {
        JobDataNodeLine dataNodeLine = jobConfig.getJobShardingDataNodes().get(jobShardingItem);
        String dataSourceName = ((DataNode)((JobDataNodeEntry)dataNodeLine.getEntries().iterator().next()).getDataNodes().iterator().next()).getDataSourceName();
        StandardPipelineDataSourceConfiguration actualDataSourceConfig = jobConfig.getDataSourceConfig().getActualDataSourceConfiguration(dataSourceName);
        return new IncrementalDumperContext(new DumperCommonContext(dataSourceName, (PipelineDataSourceConfiguration)actualDataSourceConfig, JobDataNodeLineConvertUtils.buildTableNameMapper((JobDataNodeLine)dataNodeLine), tableAndSchemaNameMapper), jobConfig.getJobId(), jobConfig.isDecodeWithTX());
    }

    private TransmissionJobItemProgress getTransmissionJobItemProgress(CDCJobConfiguration jobConfig, PipelineDataSourceManager dataSourceManager, IncrementalDumperContext incrementalDumperContext) throws SQLException {
        TransmissionJobItemProgress result = new TransmissionJobItemProgress();
        result.setSourceDatabaseType(jobConfig.getSourceDatabaseType());
        result.setDataSourceName(incrementalDumperContext.getCommonContext().getDataSourceName());
        IncrementalTaskPositionManager positionManager = new IncrementalTaskPositionManager(incrementalDumperContext.getCommonContext().getDataSourceConfig().getDatabaseType());
        IncrementalTaskProgress incrementalTaskProgress = new IncrementalTaskProgress(positionManager.getPosition(null, incrementalDumperContext, dataSourceManager));
        result.setIncremental(new JobItemIncrementalTasksProgress(incrementalTaskProgress));
        return result;
    }

    public void start(String jobId, PipelineSink sink) {
        CDCJob job = new CDCJob(sink);
        PipelineJobRegistry.add((String)jobId, (PipelineJob)job);
        this.enable(jobId);
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        OneOffJobBootstrap oneOffJobBootstrap = new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)), (ElasticJob)job, jobConfigPOJO.toJobConfiguration());
        job.getJobRunnerManager().setJobBootstrap((JobBootstrap)oneOffJobBootstrap);
        oneOffJobBootstrap.execute();
    }

    private void enable(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().setProperty("start_time_millis", String.valueOf(System.currentTimeMillis()));
        jobConfigPOJO.getProps().remove("stop_time");
        PipelineAPIFactory.getJobConfigurationAPI((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfigPOJO.getJobName())).updateJobConfiguration(jobConfigPOJO);
    }

    public void disable(String jobId) {
        JobConfigurationPOJO jobConfigPOJO = PipelineJobIdUtils.getElasticJobConfigurationPOJO((String)jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DateTimeFormatterFactory.getStandardFormatter()));
        PipelineAPIFactory.getJobConfigurationAPI((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfigPOJO.getJobName())).updateJobConfiguration(jobConfigPOJO);
    }

    public void drop(String jobId) {
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)this.jobConfigManager.getJobConfiguration(jobId);
        this.jobManager.drop(jobId);
        this.cleanup(jobConfig);
    }

    private void cleanup(CDCJobConfiguration jobConfig) {
        for (Map.Entry entry : jobConfig.getDataSourceConfig().getRootConfig().getDataSources().entrySet()) {
            try {
                StandardPipelineDataSourceConfiguration pipelineDataSourceConfig = new StandardPipelineDataSourceConfiguration((Map)entry.getValue());
                new IncrementalTaskPositionManager(pipelineDataSourceConfig.getDatabaseType()).destroyPosition(jobConfig.getJobId(), (PipelineDataSourceConfiguration)pipelineDataSourceConfig);
            }
            catch (SQLException ex) {
                log.warn("job destroying failed, jobId={}, dataSourceName={}", new Object[]{jobConfig.getJobId(), entry.getKey(), ex});
            }
        }
    }

    public Collection<CDCJobItemInfo> getJobItemInfos(String jobId) {
        CDCJobConfiguration jobConfig = (CDCJobConfiguration)new PipelineJobConfigurationManager((PipelineJobType)this.jobType).getJobConfiguration(jobId);
        ShardingSphereDatabase database = PipelineContextManager.getProxyContext().getContextManager().getMetaDataContexts().getMetaData().getDatabase(jobConfig.getDatabaseName());
        LinkedList<CDCJobItemInfo> result = new LinkedList<CDCJobItemInfo>();
        for (TransmissionJobItemInfo each : new TransmissionJobManager((PipelineJobType)this.jobType).getJobItemInfos(jobId)) {
            TransmissionJobItemProgress jobItemProgress = each.getJobItemProgress();
            String confirmedPosition = null == jobItemProgress ? "" : jobItemProgress.getIncremental().getIncrementalPosition().map(Object::toString).orElse("");
            String currentPosition = null == jobItemProgress ? "" : this.getCurrentPosition(database, jobItemProgress.getDataSourceName());
            result.add(new CDCJobItemInfo(each, confirmedPosition, currentPosition));
        }
        return result;
    }

    private String getCurrentPosition(ShardingSphereDatabase database, String dataSourceName) {
        String string;
        block9: {
            StorageUnit storageUnit = (StorageUnit)database.getResourceMetaData().getStorageUnits().get(dataSourceName);
            DialectPipelineSQLBuilder sqlBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)storageUnit.getStorageType());
            Optional queryCurrentPositionSQL = sqlBuilder.buildQueryCurrentPositionSQL();
            if (!queryCurrentPositionSQL.isPresent()) {
                return "";
            }
            Connection connection = storageUnit.getDataSource().getConnection();
            try {
                ResultSet resultSet = connection.createStatement().executeQuery((String)queryCurrentPositionSQL.get());
                resultSet.next();
                string = resultSet.getString(1);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PipelineInternalException((Throwable)ex);
                }
            }
            connection.close();
        }
        return string;
    }

    public void commit(String jobId) throws SQLException {
    }

    public void rollback(String jobId) throws SQLException {
    }

    public String getType() {
        return "STREAMING";
    }
}

