/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.checker.ReadwriteSplittingRuleStatementChecker;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.AlterReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

@DistSQLExecutorCurrentRuleRequired(value=ReadwriteSplittingRule.class)
public final class AlterReadwriteSplittingRuleExecutor
implements DatabaseRuleAlterExecutor<AlterReadwriteSplittingRuleStatement, ReadwriteSplittingRule, ReadwriteSplittingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ReadwriteSplittingRule rule;

    public void checkBeforeUpdate(AlterReadwriteSplittingRuleStatement sqlStatement) {
        ReadwriteSplittingRuleStatementChecker.checkAlteration(this.database, sqlStatement.getRules(), this.rule.getConfiguration());
    }

    public ReadwriteSplittingRuleConfiguration buildToBeAlteredRuleConfiguration(AlterReadwriteSplittingRuleStatement sqlStatement) {
        return ReadwriteSplittingRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public ReadwriteSplittingRuleConfiguration buildToBeDroppedRuleConfiguration(ReadwriteSplittingRuleConfiguration toBeAlteredRuleConfig) {
        Collection<String> unusedLoadBalancers = UnusedAlgorithmFinder.findUnusedLoadBalancers(this.rule.getConfiguration());
        HashMap toBeDroppedLoadBalancers = new HashMap(unusedLoadBalancers.size(), 1.0f);
        unusedLoadBalancers.forEach(each -> toBeDroppedLoadBalancers.put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getLoadBalancers().get(each)));
        return new ReadwriteSplittingRuleConfiguration(Collections.emptyList(), toBeDroppedLoadBalancers);
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<AlterReadwriteSplittingRuleStatement> getType() {
        return AlterReadwriteSplittingRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

