/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.checker.ActiveVersionChecker;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.GlobalRuleNodePath;

public final class GlobalRuleChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return GlobalRuleNodePath.getRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        Optional ruleTypeName = GlobalRuleNodePath.findRuleTypeNameFromActiveVersion((String)event.getKey());
        if (!ruleTypeName.isPresent()) {
            return;
        }
        ActiveVersionChecker.checkActiveVersion(contextManager, event);
        Optional ruleConfig = contextManager.getPersistServiceFacade().getMetaDataPersistService().getGlobalRuleService().load((String)ruleTypeName.get());
        Preconditions.checkArgument((boolean)ruleConfig.isPresent(), (String)"Can not find rule configuration with name: %s", ruleTypeName.get());
        contextManager.getMetaDataContextManager().getGlobalConfigurationManager().alterGlobalRuleConfiguration((RuleConfiguration)ruleConfig.get());
    }
}

