/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class TableMetaDataNodePath {
    private static final String ROOT_NODE = "/metadata";
    private static final String SCHEMAS_NODE = "schemas";
    private static final String TABLES_NODE = "tables";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";
    private static final String TABLES_PATTERN = "/([\\w\\-]+)/schemas/([\\w\\-]+)/tables";
    private static final String ACTIVE_VERSION_SUFFIX = "/([\\w\\-]+)/active_version";
    private static final String TABLE_SUFFIX = "/([\\w\\-]+)$";

    public static String getMetaDataTablesPath(String databaseName, String schemaName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE);
    }

    public static String getTableActiveVersionPath(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName, ACTIVE_VERSION_NODE);
    }

    public static String getTableVersionsPath(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName, VERSIONS_NODE);
    }

    public static String getTableVersionPath(String databaseName, String schemaName, String tableName, String version) {
        return String.join((CharSequence)"/", TableMetaDataNodePath.getTableVersionsPath(databaseName, schemaName, tableName), version);
    }

    public static String getTablePath(String databaseName, String schemaName, String tableName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, SCHEMAS_NODE, schemaName, TABLES_NODE, tableName);
    }

    public static Optional<String> getTableNameByActiveVersionPath(String path) {
        Pattern pattern = Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)/active_version", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static Optional<String> findTableName(String path) {
        Pattern pattern = Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(3)) : Optional.empty();
    }

    public static boolean isTableActiveVersionPath(String path) {
        return Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)/active_version", 2).matcher(path).find();
    }

    public static boolean isTablePath(String path) {
        return Pattern.compile("/metadata/([\\w\\-]+)/schemas/([\\w\\-]+)/tables/([\\w\\-]+)$", 2).matcher(path).find();
    }

    @Generated
    private TableMetaDataNodePath() {
    }
}

