/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.database.visitor;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.SQLStatementVisitorFacade;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatementType;

public final class SQLStatementVisitorFactory {
    public static SQLStatementVisitor newInstance(DatabaseType databaseType, SQLVisitorRule visitorRule) {
        SQLStatementVisitorFacade facade = (SQLStatementVisitorFacade)DatabaseTypedSPILoader.getService(SQLStatementVisitorFacade.class, (DatabaseType)databaseType);
        return SQLStatementVisitorFactory.createParseTreeVisitor(facade, visitorRule.getType());
    }

    private static SQLStatementVisitor createParseTreeVisitor(SQLStatementVisitorFacade visitorFacade, SQLStatementType type) {
        switch (type) {
            case DML: {
                return (SQLStatementVisitor)visitorFacade.getDMLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DDL: {
                return (SQLStatementVisitor)visitorFacade.getDDLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case TCL: {
                return (SQLStatementVisitor)visitorFacade.getTCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DCL: {
                return (SQLStatementVisitor)visitorFacade.getDCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DAL: {
                return (SQLStatementVisitor)visitorFacade.getDALVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case RL: {
                return (SQLStatementVisitor)visitorFacade.getRLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        throw new SQLParsingException(type.name());
    }

    @Generated
    private SQLStatementVisitorFactory() {
    }
}

