/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk;

import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.GlobalOpenTelemetry;
import org.apache.shardingsphere.shade.io.opentelemetry.context.propagation.ContextPropagators;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.OpenTelemetrySdk;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkLoggerProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SdkTracerProvider;

public final class OpenTelemetrySdkBuilder {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLoggerProvider loggerProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLoggerProvider(SdkLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set(sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkLoggerProvider loggerProvider;
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        if ((loggerProvider = this.loggerProvider) == null) {
            loggerProvider = SdkLoggerProvider.builder().build();
        }
        return new OpenTelemetrySdk(tracerProvider, meterProvider, loggerProvider, this.propagators);
    }
}

