/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.LowAllocationTraceRequestMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final Deque<LowAllocationTraceRequestMarshaler> marshalerPool = new ArrayDeque<LowAllocationTraceRequestMarshaler>();
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final MemoryMode memoryMode;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.memoryMode = memoryMode;
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder(this.builder.copy(), this.memoryMode);
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationTraceRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationTraceRequestMarshaler();
            }
            LowAllocationTraceRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(spans);
            return this.delegate.export(exportMarshaler, spans.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
        return this.delegate.export(request, spans.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.memoryMode));
        return joiner.toString();
    }
}

