/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.NumberDataPointMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.metrics.v1.internal.Sum;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.SumData;

final class SumMarshaler
extends MarshalerWithSize {
    private final NumberDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;
    private final boolean isMonotonic;

    static SumMarshaler create(SumData<? extends PointData> sum) {
        NumberDataPointMarshaler[] dataPointMarshalers = NumberDataPointMarshaler.createRepeated(sum.getPoints());
        return new SumMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(sum.getAggregationTemporality()), sum.isMonotonic());
    }

    private SumMarshaler(NumberDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality, boolean isMonotonic) {
        super(SumMarshaler.calculateSize(dataPoints, aggregationTemporality, isMonotonic));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
        this.isMonotonic = isMonotonic;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Sum.DATA_POINTS, this.dataPoints);
        output.serializeEnum(Sum.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
        output.serializeBool(Sum.IS_MONOTONIC, this.isMonotonic);
    }

    private static int calculateSize(NumberDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality, boolean isMonotonic) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Sum.DATA_POINTS, (Marshaler[])dataPoints);
        size += MarshalerUtil.sizeEnum(Sum.AGGREGATION_TEMPORALITY, aggregationTemporality);
        return size += MarshalerUtil.sizeBool(Sum.IS_MONOTONIC, isMonotonic);
    }
}

